/*
 * Decompiled with CFR 0.152.
 */
package papers.smoothing;

import java.io.File;
import java.io.FileFilter;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.converters.ArffSaver;

public class FilteringUtilities {
    public static void fixClassValuesFromMatlab2Weka() throws Exception {
        String[] splits = new String[]{"TRAIN", "TEST"};
        String RAWdataPath = "Z:/Data/TSCProblems/";
        String writePath = "Z:/Data/TSCProblems_Gaussian_FCV/";
        String dataPath = "Z:/Data/TSCProblems_Gaussian/";
        for (File dsetFile : new File(dataPath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            String dset = dsetFile.getName();
            System.out.println("dset = " + dset);
            for (String split : splits) {
                String baseDset = dset.split("-")[0];
                Instances rawdata = ClassifierTools.loadData(RAWdataPath + baseDset + "/" + baseDset);
                Instances data = ClassifierTools.loadData(dataPath + dset + "/" + dset + "_" + split);
                Attribute rawClassAtt = rawdata.classAttribute();
                FastVector<String> attVals = new FastVector<String>();
                for (int i = 0; i < rawClassAtt.numValues(); ++i) {
                    attVals.add(rawClassAtt.value(i));
                }
                Attribute newClassAtt = new Attribute(rawClassAtt.name(), attVals);
                double[] classVals = data.attributeToDoubleArray(data.classIndex());
                data.setClassIndex(0);
                data.deleteAttributeAt(data.numAttributes() - 1);
                data.insertAttributeAt(newClassAtt, data.numAttributes());
                data.setClassIndex(data.numAttributes() - 1);
                for (int i = 0; i < classVals.length; ++i) {
                    data.instance(i).setClassValue(classVals[i]);
                }
                ArffSaver saver = new ArffSaver();
                saver.setInstances(data);
                saver.setFile(new File(writePath + dset + "/" + dset + "_" + split + ".arff"));
                saver.writeBatch();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FilteringUtilities.fixClassValuesFromMatlab2Weka();
    }
}

