/*
 * Decompiled with CFR 0.152.
 */
package papers.smoothing;

import development.DataSets;
import development.MultipleClassifierEvaluation;
import fileIO.OutFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import statistics.tests.TwoSampleTests;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.MultipleClassifierResultsCollection;
import utilities.StatisticalUtilities;
import vector_classifiers.CAWPE;
import vector_classifiers.ChooseClassifierFromFile;
import vector_classifiers.ChooseDatasetFromFile;
import weka.core.Instances;

public class FilteringEvaluations {
    public static String[] UCRDsetsNoPigs = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW", "Earthquakes", "ECG200", "ECG5000", "ECGFiveDays", "FaceAll", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "GunPoint", "Ham", "Haptics", "Herring", "InlineSkate", "InsectWingbeatSound", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "Mallat", "Meat", "MedicalImages", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MoteStrain", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Phoneme", "Plane", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "Wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "Yoga"};

    public static void main(String[] args) throws Exception {
        FilteringEvaluations.selectFilterAndWriteResults();
        FilteringEvaluations.extractFilterParameterSelectionsFromOptimisedFoldFiles();
        FilteringEvaluations.whatIfWeJustEnsembleOverOptimisedFilters();
    }

    public static void performStandardClassifierComparisonWithFilteredAndUnfilteredDatasets() throws Exception {
        String expName = "RotFvsFilterEnesmble_MA,PCA,EXP,SG,DFT";
        String basePath = "C:/JamesLPHD/TSC_Smoothing/";
        String analysisPath = basePath + "Analysis/";
        String baseResultsPath = basePath + "Results/";
        String unfilteredResultsPath = baseResultsPath + "TSC_Unfiltered/";
        String baseClassifier = "RotF";
        MultipleClassifierEvaluation mce = new MultipleClassifierEvaluation(analysisPath, expName, 30);
        mce.setBuildMatlabDiagrams(true);
        mce.setDatasets(UCRDsetsNoPigs);
        mce.setPerformPostHocDsetResultsClustering(true);
        mce.addAllDatasetGroupingsInDirectory("Z:/Data/DatasetGroupings/UCRUEAGroupings_77Dsets_Nonpigs/");
        mce.readInClassifier(baseClassifier, unfilteredResultsPath);
        mce.readInClassifier(baseClassifier + "_6FilterEnsemble", baseResultsPath + "ENSEMBLES");
        mce.runComparison();
    }

    public static void selectFilterAndWriteResults() throws Exception {
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] baseDatasets = UCRDsetsNoPigs;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        String unfilteredResultsPath = "TSC_Unfiltered";
        String unfilteredReadPath = baseReadPath + unfilteredResultsPath + "/";
        String[] filterSuffixes = new String[]{"_DFTFiltered", "_EXPFiltered", "_SGFiltered", "_PCAFiltered", "_MAFiltered", "_GFiltered"};
        String[] filterResultsPaths = new String[]{unfilteredReadPath, baseReadPath + "TSC_FFT_zeroed", baseReadPath + "TSC_Exponential", baseReadPath + "TSC_SavitzkyGolay", baseReadPath + "TSCProblems_PCA_smoothed", baseReadPath + "TSCProblems_MovingAverage", baseReadPath + "TSCProblems_Gaussian"};
        for (String classifier : new String[]{"ED", "DTWCV", "RotF"}) {
            String[] classifierNames = new String[filterResultsPaths.length];
            classifierNames[0] = classifier;
            for (int i = 0; i < filterSuffixes.length; ++i) {
                classifierNames[i + 1] = classifier + filterSuffixes[i];
            }
            for (int dset = 0; dset < numBaseDatasets; ++dset) {
                String baseDset = baseDatasets[dset];
                for (int fold = 0; fold < numFolds; ++fold) {
                    ChooseClassifierFromFile ccff = new ChooseClassifierFromFile();
                    ccff.setName(classifier + "_FILTERED3");
                    ccff.setClassifiers(classifierNames);
                    ccff.setRelationName(baseDset);
                    ccff.setResultsPath(filterResultsPaths);
                    ccff.setResultsWritePath(baseReadPath + "FilterSelected/");
                    ccff.setFold(fold);
                    ccff.buildClassifier(null);
                }
            }
        }
    }

    public static void selectFilterParametersAndWriteResults() throws Exception {
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] baseDatasets = UCRDsetsNoPigs;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        String unfilteredReadPath = baseReadPath + "TSC_Unfiltered/";
        String[] filterSuffixes = new String[]{"_GFiltered"};
        String[] filterResultsPaths = new String[]{"TSCProblems_Gaussian"};
        for (int i = 0; i < filterResultsPaths.length; ++i) {
            String filterReadPath = baseReadPath + filterResultsPaths[i] + "/";
            String filterSuffix = filterSuffixes[i];
            for (String classifier : new String[]{"ED", "DTWCV", "RotF"}) {
                for (int dset = 0; dset < numBaseDatasets; ++dset) {
                    final String baseDset = baseDatasets[dset];
                    File sourceLocation = new File(unfilteredReadPath + classifier + "/Predictions/" + baseDset + "/");
                    File targetLocation = new File(filterReadPath + classifier + "/Predictions/" + baseDset + "/");
                    targetLocation.mkdirs();
                    for (File foldFile : sourceLocation.listFiles()) {
                        Files.copy(foldFile.toPath(), new File(targetLocation.getAbsolutePath() + "/" + foldFile.getName()).toPath(), new CopyOption[0]);
                    }
                    for (int fold = 0; fold < numFolds; ++fold) {
                        ChooseDatasetFromFile cdff = new ChooseDatasetFromFile();
                        cdff.setName(classifier + filterSuffix);
                        cdff.setClassifier(classifier);
                        cdff.setFinalRelationName(baseDset);
                        cdff.setResultsPath(filterReadPath);
                        cdff.setFold(fold);
                        Object[] datasets = new File(filterReadPath + classifier + "/Predictions/").list(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.split("-")[0].split("_")[0].equals(baseDset);
                            }
                        });
                        Arrays.sort(datasets);
                        if (!((String)datasets[0]).equals(baseDset)) {
                            throw new Exception("hwut" + baseDset + "/n" + Arrays.toString(datasets));
                        }
                        cdff.setRelationNames((String[])datasets);
                        cdff.buildClassifier(null);
                    }
                    for (File foldFile : targetLocation.listFiles()) {
                        foldFile.delete();
                    }
                    targetLocation.delete();
                }
            }
        }
    }

    public static void performSomeSimpleStatsOnWhetherFilteringIsAtAllReasonableWithTestData() throws Exception {
        double P_VAL = 0.05;
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] classifiers = new String[]{"ED"};
        String[] baseDatasets = DataSets.fileNames;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        boolean testResultsOnly = false;
        boolean cleanResults = true;
        boolean allowMissing = false;
        MultipleClassifierResultsCollection[] mcrcs = new MultipleClassifierResultsCollection[numBaseDatasets];
        boolean[] aFilteredVersionIsSigBetter = new boolean[numBaseDatasets];
        boolean[] aFilteredVersionIsBetter = new boolean[numBaseDatasets];
        boolean[] unFilteredVersionIsSigBetterThanAllFiltered = new boolean[numBaseDatasets];
        for (int i = 0; i < numBaseDatasets; ++i) {
            MultipleClassifierResultsCollection mcrc;
            final String datasetBase = baseDatasets[i];
            Object[] datasets = new File(baseReadPath + classifiers[0] + "/Predictions/").list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.split("-")[0].split("_")[0].equals(datasetBase);
                }
            });
            Arrays.sort(datasets);
            if (!((String)datasets[0]).equals(datasetBase)) {
                throw new Exception("hwut" + datasetBase + "/n" + Arrays.toString(datasets));
            }
            mcrcs[i] = mcrc = new MultipleClassifierResultsCollection(classifiers, (String[])datasets, numFolds, baseReadPath, testResultsOnly, cleanResults, allowMissing);
            double[][] resFolds = mcrc.getAccuracies()[1][0];
            double[] resDsets = StatisticalUtilities.averageFinalDimension(resFolds);
            double unfilteredAcc = resDsets[0];
            boolean allFilteredAreSigWorse = true;
            for (int j = 1; j < resDsets.length; ++j) {
                double p = TwoSampleTests.studentT_PValue(resFolds[0], resFolds[j]);
                if (resDsets[j] > unfilteredAcc) {
                    aFilteredVersionIsBetter[i] = true;
                    if (!(p < 0.05)) continue;
                    aFilteredVersionIsSigBetter[i] = true;
                    continue;
                }
                if (!(p > 0.05)) continue;
                allFilteredAreSigWorse = false;
            }
            unFilteredVersionIsSigBetterThanAllFiltered[i] = allFilteredAreSigWorse;
        }
        System.out.println("aFilteredVersionIsSigBetter: " + FilteringEvaluations.countNumTrue(aFilteredVersionIsSigBetter));
        System.out.println("aFilteredVersionIsBetter: " + FilteringEvaluations.countNumTrue(aFilteredVersionIsBetter));
        System.out.println("unFilteredVersionIsSigBetterThanAllFiltered: " + FilteringEvaluations.countNumTrue(unFilteredVersionIsSigBetterThanAllFiltered));
    }

    public static int countNumTrue(boolean[] arr) {
        int counter = 0;
        for (boolean b : arr) {
            if (!b) continue;
            ++counter;
        }
        return counter;
    }

    public static void extractFilterParameterSelectionsFromOptimisedFoldFiles() throws IOException, Exception {
        int i;
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] baseDatasets = UCRDsetsNoPigs;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        String unfilteredReadPath = baseReadPath + "TSC_Unfiltered/";
        String[] filterSuffixes = new String[]{"_DFTFiltered", "_EXPFiltered", "_SGFiltered", "_PCAFiltered", "_MAFiltered", "_GFiltered"};
        String[] filterResultsPaths = new String[]{"TSC_FFT_zeroed", "TSC_Exponential", "TSC_SavitzkyGolay", "TSCProblems_PCA_smoothed", "TSCProblems_MovingAverage", "TSCProblems_Gaussian"};
        ArrayList<String> tssColumnHeaders = new ArrayList<String>();
        ArrayList<String> tssRowHeaders = new ArrayList<String>();
        ArrayList tsstrainAccs = new ArrayList();
        ArrayList tsstestAccs = new ArrayList();
        ArrayList tssparas = new ArrayList();
        int tssColumnIndex = -1;
        boolean rowHeadersFinished = false;
        for (int i2 = 0; i2 < filterResultsPaths.length; ++i2) {
            String filterReadPath = baseReadPath + filterResultsPaths[i2] + "/";
            String filterSuffix = filterSuffixes[i2];
            for (String classifier : new String[]{"ED", "DTWCV", "RotF"}) {
                String filteredClassifier = classifier + filterSuffix;
                tssColumnHeaders.add(filteredClassifier);
                tsstrainAccs.add(new ArrayList());
                tsstestAccs.add(new ArrayList());
                tssparas.add(new ArrayList());
                ++tssColumnIndex;
                OutFile clsfrTrainAccs = new OutFile(filterReadPath + filteredClassifier + "bestTrainACCS.csv");
                OutFile clsfrParas = new OutFile(filterReadPath + filteredClassifier + "parasSelected.csv");
                clsfrTrainAccs.writeString("fold");
                clsfrParas.writeString("fold");
                for (int j = 0; j < numFolds; ++j) {
                    clsfrTrainAccs.writeString("," + j);
                    clsfrParas.writeString("," + j);
                }
                clsfrTrainAccs.writeLine("");
                clsfrParas.writeLine("");
                for (int dset = 0; dset < numBaseDatasets; ++dset) {
                    String baseDset = baseDatasets[dset];
                    clsfrTrainAccs.writeString(baseDset);
                    clsfrParas.writeString(baseDset);
                    for (int fold = 0; fold < numFolds; ++fold) {
                        ClassifierResults crTrain = new ClassifierResults(filterReadPath + filteredClassifier + "/Predictions/" + baseDset + "/trainFold" + fold + ".csv");
                        ClassifierResults crTest = new ClassifierResults(filterReadPath + filteredClassifier + "/Predictions/" + baseDset + "/trainFold" + fold + ".csv");
                        String selectedDataset = "";
                        try {
                            selectedDataset = FilteringEvaluations.parseDatasetChosenFromParasList(crTrain.getParas());
                        }
                        catch (Exception ex) {
                            throw new Exception("Problem with: " + filterReadPath + filteredClassifier + "/Predictions/" + baseDset + "/trainFold" + fold + ".csv\n");
                        }
                        String paras = FilteringEvaluations.parseFilterParasFromDatasetName(selectedDataset);
                        clsfrTrainAccs.writeString("," + crTrain.acc);
                        clsfrTrainAccs.writeString("," + paras);
                        ((ArrayList)tsstrainAccs.get(tssColumnIndex)).add(crTrain.acc);
                        ((ArrayList)tsstestAccs.get(tssColumnIndex)).add(crTest.acc);
                        ((ArrayList)tssparas.get(tssColumnIndex)).add(paras);
                        if (rowHeadersFinished) continue;
                        tssRowHeaders.add(baseDset + "_" + fold);
                    }
                    clsfrTrainAccs.writeLine("");
                    clsfrParas.writeLine("");
                }
                rowHeadersFinished = true;
                clsfrTrainAccs.closeFile();
                clsfrParas.closeFile();
            }
        }
        OutFile allTrainAccs = new OutFile(baseReadPath + "AllFilters_BESTTRAINACCS_TSSStyle.csv");
        OutFile allTestAccs = new OutFile(baseReadPath + "AllFilters_TESTACCS_TSSStyle.csv");
        OutFile allParas = new OutFile(baseReadPath + "AllFilters_PARASSELECTED_TSSStyle.csv");
        allTrainAccs.writeString("dset_fold");
        allTestAccs.writeString("dset_fold");
        allParas.writeString("dset_fold");
        for (i = 0; i < tssColumnHeaders.size(); ++i) {
            allTrainAccs.writeString("," + (String)tssColumnHeaders.get(i));
            allTestAccs.writeString("," + (String)tssColumnHeaders.get(i));
            allParas.writeString("," + (String)tssColumnHeaders.get(i));
        }
        allTrainAccs.writeLine("");
        allTestAccs.writeLine("");
        allParas.writeLine("");
        for (i = 0; i < tssRowHeaders.size(); ++i) {
            allTrainAccs.writeString((String)tssRowHeaders.get(i));
            allTestAccs.writeString((String)tssRowHeaders.get(i));
            allParas.writeString((String)tssRowHeaders.get(i));
            for (int j = 0; j < tssColumnHeaders.size(); ++j) {
                allTrainAccs.writeString("," + ((ArrayList)tsstrainAccs.get(j)).get(i));
                allTestAccs.writeString("," + ((ArrayList)tsstestAccs.get(j)).get(i));
                allParas.writeString("," + (String)((ArrayList)tssparas.get(j)).get(i));
            }
            allTrainAccs.writeLine("");
            allTestAccs.writeLine("");
            allParas.writeLine("");
        }
        allTrainAccs.closeFile();
        allTestAccs.closeFile();
        allParas.closeFile();
    }

    public static String parseDatasetChosenFromParasList(String parasLine) throws Exception {
        String[] parts = parasLine.split(",");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].contains("originalDataset")) continue;
            return parts[i + 1];
        }
        throw new Exception("Cant find originalDataset para");
    }

    public static String parseFilterParasFromDatasetName(String datasetName) {
        String[] parts = null;
        String[] temp = datasetName.split("-");
        if (temp.length == 1) {
            return "0";
        }
        String filterTitle = temp[1].split("_")[0];
        if (filterTitle.equals("PCA")) {
            parts = datasetName.split("_");
            return "0." + parts[1].replace("-", "");
        }
        if (filterTitle.equals("EXP")) {
            parts = datasetName.split("_");
            return parts[1].replace("-", "");
        }
        if (filterTitle.equals("SG")) {
            parts = datasetName.split("_");
            return parts[2].replace("n", "") + "_" + parts[3].replace("m", "").replace("-", "");
        }
        if (filterTitle.equals("MA")) {
            parts = datasetName.split("_");
            return parts[1].replace("-", "");
        }
        if (filterTitle.equals("DFT")) {
            if (filterTitle.equals("log2")) {
                return "log2";
            }
            if (datasetName.equals("sqrt")) {
                return "sqrt";
            }
            parts = datasetName.split("_");
            return "0." + parts[1].replace("-", "");
        }
        if (filterTitle.equals("Sieved")) {
            return "unsupported so far";
        }
        return "0";
    }

    public static void whatIfWeJustEnsembleOverOptimisedFilters() throws Exception {
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String writePath = baseReadPath + "ENSEMBLES/";
        String[] baseDatasets = UCRDsetsNoPigs;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        for (String classifier : new String[]{"ED", "DTWCV", "RotF"}) {
            String[] filteredClassifiers = new String[]{classifier + "", classifier + "_DFTFiltered", classifier + "_EXPFiltered", classifier + "_SGFiltered", classifier + "_PCAFiltered", classifier + "_MAFiltered", classifier + "_GFiltered"};
            String[] filterResultsPaths = new String[]{baseReadPath + "TSC_Unfiltered/", baseReadPath + "TSC_FFT_zeroed/", baseReadPath + "TSC_Exponential/", baseReadPath + "TSC_SavitzkyGolay/", baseReadPath + "TSCProblems_PCA_smoothed/", baseReadPath + "TSCProblems_MovingAverage/", baseReadPath + "TSCProblems_Gaussian/"};
            for (int dset = 0; dset < numBaseDatasets; ++dset) {
                String baseDset = baseDatasets[dset];
                Instances train = ClassifierTools.loadData("Z:/Data/TSCProblems/" + baseDset + "/" + baseDset + "_TRAIN");
                Instances test = ClassifierTools.loadData("Z:/Data/TSCProblems/" + baseDset + "/" + baseDset + "_TEST");
                for (int fold = 0; fold < numFolds; ++fold) {
                    Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, fold);
                    CAWPE hesca = new CAWPE();
                    hesca.setEnsembleIdentifier(classifier + "_" + filteredClassifiers.length + "FilterEnsemble");
                    hesca.setBuildIndividualsFromResultsFiles(true);
                    hesca.setClassifiers(null, filteredClassifiers, null);
                    hesca.setResultsFileLocationParameters(filterResultsPaths, baseDset, fold);
                    hesca.setResultsFileWritingLocation(writePath);
                    hesca.setRandSeed(fold);
                    hesca.setPerformCV(true);
                    hesca.buildClassifier(data[0]);
                    for (int i = 0; i < data[1].numInstances(); ++i) {
                        hesca.classifyInstance(data[1].instance(i));
                    }
                    hesca.writeEnsembleTrainTestFiles(data[1].attributeToDoubleArray(data[1].classIndex()), true);
                }
            }
        }
    }
}

