/*
 * Decompiled with CFR 0.152.
 */
package papers.bagnall17defaultparas;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.CAWPE;
import vector_classifiers.TunedSVM;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class UCIExperiments {
    public static String[] classifiers = new String[]{"1NN", "SVML_0", "SVMQ_0", "SVMRBF_0", "SVM_0ptKernel"};
    public static double propInTrain = 0.5;
    static String[] fileNames = new String[]{"abalone", "acute-inflammation", "acute-nephritis", "adult", "annealing", "arrhythmia", "audiology-std", "balance-scale", "balloons", "bank", "blood", "breast-cancer", "breast-cancer-wisc", "breast-cancer-wisc-diag", "breast-cancer-wisc-prog", "breast-tissue", "car", "cardiotocography-10clases", "cardiotocography-3clases", "chess-krvk", "chess-krvkp", "congressional-voting", "conn-bench-sonar-mines-rocks", "conn-bench-vowel-deterding", "connect-4", "contrac", "credit-approval", "cylinder-bands", "dermatology", "echocardiogram", "ecoli", "energy-y1", "energy-y2", "fertility", "flags", "glass", "haberman-survival", "hayes-roth", "heart-cleveland", "heart-hungarian", "heart-switzerland", "heart-va", "hepatitis", "hill-valley", "horse-colic", "ilpd-indian-liver", "image-segmentation", "ionosphere", "iris", "led-display", "lenses", "letter", "libras", "low-res-spect", "lung-cancer", "lymphography", "magic", "mammographic", "miniboone", "molec-biol-promoter", "molec-biol-splice", "monks-1", "monks-2", "monks-3", "mushroom", "musk-1", "musk-2", "nursery", "oocytes_merluccius_nucleus_4d", "oocytes_merluccius_states_2f", "oocytes_trisopterus_nucleus_2f", "oocytes_trisopterus_states_5b", "optical", "ozone", "page-blocks", "parkinsons", "pendigits", "pima", "pittsburg-bridges-MATERIAL", "pittsburg-bridges-REL-L", "pittsburg-bridges-SPAN", "pittsburg-bridges-T-OR-D", "pittsburg-bridges-TYPE", "planning", "plant-margin", "plant-shape", "plant-texture", "post-operative", "primary-tumor", "ringnorm", "seeds", "semeion", "soybean", "spambase", "spect", "spectf", "statlog-australian-credit", "statlog-german-credit", "statlog-heart", "statlog-image", "statlog-landsat", "statlog-shuttle", "statlog-vehicle", "steel-plates", "synthetic-control", "teaching", "thyroid", "tic-tac-toe", "titanic", "trains", "twonorm", "vertebral-column-2clases", "vertebral-column-3clases", "wall-following", "waveform", "waveform-noise", "wine", "wine-quality-red", "wine-quality-white", "yeast", "zoo"};

    public static void generateScripts(boolean grace, int mem) {
        String path = DataSets.dropboxPath + "Code\\Cluster Scripts\\UCIScripts\\";
        File f = new File(path);
        int folds = 30;
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        for (String s : classifiers) {
            OutFile of2 = grace ? new OutFile(path + s + "Grace.txt") : new OutFile(path + s + ".txt");
            for (String a : fileNames) {
                OutFile of = grace ? new OutFile(path + s + a + "Grace.bsub") : new OutFile(path + s + a + ".bsub");
                of.writeLine("#!/bin/csh");
                if (grace) {
                    of.writeLine("#BSUB -q short");
                } else {
                    of.writeLine("#BSUB -q long-eth");
                }
                of.writeLine("#BSUB -J " + s + a + "[1-" + folds + "]");
                of.writeLine("#BSUB -oo output/" + a + ".out");
                of.writeLine("#BSUB -eo error/" + a + ".err");
                if (grace) {
                    of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                    of.writeLine("#BSUB -M " + mem);
                    of.writeLine(" module add java/jdk/1.8.0_31");
                } else {
                    of.writeLine("#BSUB -R \"rusage[mem=" + (2000 + mem) + "]\"");
                    of.writeLine("#BSUB -M " + (2000 + mem));
                    of.writeLine("module add java/jdk1.8.0_51");
                }
                of.writeLine("java -jar UCI.jar " + s + " " + a + " $LSB_JOBINDEX");
                if (grace) {
                    of2.writeLine("bsub < Scripts/UCIScripts/" + s + a + "Grace.bsub");
                    continue;
                }
                of2.writeLine("bsub < Scripts/UCIScripts/" + s + a + ".bsub");
            }
        }
    }

    public static boolean foldComplete(String path, int fold, int numTrain, int numTest) {
        File f = new File(path + "//testFold" + fold + ".csv");
        File f2 = new File(path + "//trainFold" + fold + ".csv");
        if (!f.exists() || !f2.exists()) {
            return false;
        }
        InFile inf1 = new InFile(path + "//testFold" + fold + ".csv");
        InFile inf2 = new InFile(path + "//testFold" + fold + ".csv");
        int c1 = inf1.countLines();
        int c2 = inf2.countLines();
        return c1 >= 3 && c2 >= 3;
    }

    public static void compareTrainToTestAcc(String cls) {
    }

    public static void collateResults(int folds) {
        int i;
        String basePath = "C:\\Research\\Results\\UCIResults\\";
        for (String string : classifiers) {
            File f = new File(basePath + string);
            if (!f.isDirectory()) continue;
            OutFile clsResults = new OutFile(basePath + string + "//" + string + "Test.csv");
            OutFile missing = null;
            int missingCount = 0;
            for (int i2 = 0; i2 < fileNames.length; ++i2) {
                int j;
                String name = fileNames[i2];
                clsResults.writeString(fileNames[i2] + ",");
                String path = basePath + string + "//Predictions//" + fileNames[i2];
                if (missing != null && missingCount > 0) {
                    missing.writeString("\n");
                }
                missingCount = 0;
                for (j = 0; j < folds; ++j) {
                    f = new File(path + "//testFold" + j + ".csv");
                    if (f.exists() && f.length() > 0L) {
                        InFile inf = new InFile(path + "//testFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        clsResults.writeString(inf.readDouble() + ",");
                        continue;
                    }
                    if (missing == null) {
                        missing = new OutFile(basePath + string + "//" + string + "MISSING.csv");
                    }
                    if (missingCount == 0) {
                        missing.writeString(name);
                    }
                    ++missingCount;
                    missing.writeString("," + j);
                }
                for (j = 0; j < folds; ++j) {
                }
                clsResults.writeString("\n");
            }
            clsResults.closeFile();
        }
        OutFile acc = new OutFile(basePath + "CombinedAcc.csv");
        OutFile count = new OutFile(basePath + "CombinedCount.csv");
        OutFile diff = new OutFile(basePath + "TrainTestDiff.csv");
        for (String cls : classifiers) {
            acc.writeString("," + cls);
            count.writeString("," + cls);
            diff.writeString("," + cls);
        }
        acc.writeString("\n");
        count.writeString("\n");
        diff.writeString("\n");
        InFile[] inFileArray = new InFile[classifiers.length];
        for (i = 0; i < inFileArray.length; ++i) {
            String p = basePath + classifiers[i] + "//" + classifiers[i] + "Test.csv";
            inFileArray[i] = new File(p).exists() ? new InFile(p) : null;
            p = basePath + classifiers[i] + "//" + classifiers[i] + "Train.csv";
        }
        for (i = 0; i < fileNames.length; ++i) {
            acc.writeString(fileNames[i] + ",");
            count.writeString(fileNames[i] + ",");
            for (int j = 0; j < inFileArray.length; ++j) {
                if (inFileArray[j] == null) {
                    acc.writeString(",");
                    count.writeString("0,");
                    continue;
                }
                String[] res = inFileArray[j].readLine().split(",");
                count.writeString(res.length - 1 + ",");
                double mean = 0.0;
                for (int k = 1; k < res.length; ++k) {
                    mean += Double.parseDouble(res[k]);
                }
                if (res.length > 1) {
                    acc.writeString(mean / (double)(res.length - 1) + ",");
                    continue;
                }
                acc.writeString(",");
            }
            acc.writeString("\n");
            count.writeString("\n");
        }
    }

    public static void collateTrainTestResults(int folds) {
        int i;
        String basePath = "C:\\Research\\Results\\UCIResults\\";
        for (String cls : classifiers) {
            File f = new File(basePath + cls);
            if (!f.isDirectory()) continue;
            OutFile clsResults = new OutFile(basePath + cls + "//" + cls + "TrainTestDiffs.csv");
            OutFile missing = null;
            int missingCount = 0;
            for (int i2 = 0; i2 < fileNames.length; ++i2) {
                int j;
                String name = fileNames[i2];
                clsResults.writeString(fileNames[i2] + ",");
                String path = basePath + cls + "//Predictions//" + fileNames[i2];
                if (missing != null && missingCount > 0) {
                    missing.writeString("\n");
                }
                missingCount = 0;
                for (j = 0; j < folds; ++j) {
                    f = new File(path + "//testFold" + j + ".csv");
                    File f2 = new File(path + "//trainFold" + j + ".csv");
                    if (f2.exists() && f2.length() > 0L && f.exists() && f.length() > 0L) {
                        InFile inf = new InFile(path + "//testFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        double test = inf.readDouble();
                        inf = new InFile(path + "//trainFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        double train = inf.readDouble();
                        clsResults.writeString(test - train + ",");
                        continue;
                    }
                    if (missing == null) {
                        missing = new OutFile(basePath + cls + "//" + cls + "MISSING.csv");
                    }
                    if (missingCount == 0) {
                        missing.writeString(name);
                    }
                    ++missingCount;
                    missing.writeString("," + j);
                }
                for (j = 0; j < folds; ++j) {
                }
                clsResults.writeString("\n");
            }
            clsResults.closeFile();
        }
        OutFile diff = new OutFile(basePath + "TrainTestDiff.csv");
        for (String cls : classifiers) {
            diff.writeString("," + cls);
        }
        diff.writeString("\n");
        InFile[] allDiffs = new InFile[classifiers.length];
        for (i = 0; i < allDiffs.length; ++i) {
            String p = basePath + classifiers[i] + "//" + classifiers[i] + "TrainTestDiffs.csv";
            allDiffs[i] = new File(p).exists() ? new InFile(p) : null;
        }
        for (i = 0; i < fileNames.length; ++i) {
            diff.writeString(fileNames[i] + ",");
            for (int j = 0; j < allDiffs.length; ++j) {
                if (allDiffs[j] == null) {
                    diff.writeString(",");
                    continue;
                }
                String[] res = allDiffs[j].readLine().split(",");
                diff.writeString(res.length - 1 + ",");
                double diffMean = 0.0;
                for (int k = 1; k < res.length; ++k) {
                    diffMean += Double.parseDouble(res[k]);
                }
                if (res.length > 1) {
                    diff.writeString(diffMean / (double)(res.length - 1) + ",");
                    continue;
                }
                diff.writeString(",");
            }
            diff.writeString("\n");
        }
    }

    public static Classifier setClassifier(String classifier) {
        AbstractClassifier c = null;
        switch (classifier) {
            case "IBk": {
                c = new IBk();
                ((IBk)c).setCrossValidate(true);
                break;
            }
            case "SVMRBF_0": {
                TunedSVM c2 = new TunedSVM();
                c2.optimiseKernel(false);
                c2.optimiseParas(true);
                RBFKernel kernel2 = new RBFKernel();
                c2.setKernel(kernel2);
                c = c2;
                break;
            }
            case "SVML_0": {
                TunedSVM c3 = new TunedSVM();
                c3.optimiseKernel(false);
                c3.optimiseParas(true);
                PolyKernel p = new PolyKernel();
                p.setExponent(1.0);
                c3.setKernel(p);
                c = c3;
                break;
            }
            case "SVMQ_0": {
                TunedSVM c4 = new TunedSVM();
                c4.optimiseKernel(false);
                c4.optimiseParas(true);
                PolyKernel p2 = new PolyKernel();
                p2.setExponent(2.0);
                c4.setKernel(p2);
                c = c4;
                break;
            }
            case "SVM_0ptKernel": {
                TunedSVM c5 = new TunedSVM();
                c5.optimiseKernel(true);
                c = c5;
                break;
            }
            case "HESCA": {
                c = new CAWPE();
                break;
            }
            case "C45": {
                c = new J48();
                break;
            }
            case "NB": {
                c = new NaiveBayes();
                break;
            }
            case "SVML": {
                c = new SMO();
                PolyKernel p3 = new PolyKernel();
                p3.setExponent(1.0);
                ((SMO)c).setKernel(p3);
                break;
            }
            case "SVMQ": {
                c = new SMO();
                PolyKernel p4 = new PolyKernel();
                p4.setExponent(2.0);
                ((SMO)c).setKernel(p4);
                break;
            }
            case "BN": {
                c = new BayesNet();
                break;
            }
            case "MLP": {
                c = new MultilayerPerceptron();
                break;
            }
            case "RandF": {
                c = new RandomForest();
                ((RandomForest)c).setNumTrees(500);
                break;
            }
            case "RotF10": {
                c = new RotationForest();
                ((RotationForest)c).setNumIterations(10);
                break;
            }
            case "RotF25": {
                c = new RotationForest();
                ((RotationForest)c).setNumIterations(25);
                break;
            }
            case "RotF50": 
            case "RotF": {
                c = new RotationForest();
                ((RotationForest)c).setNumIterations(50);
                break;
            }
            case "Logistic": {
                c = new Logistic();
                break;
            }
            default: {
                System.out.println("WTF? UNKNOWN CLASSIFIER " + classifier + " Not implemented ");
                System.exit(0);
            }
        }
        return c;
    }

    public static void singleClassifierAndFold(String[] args) {
        String predictions;
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        Classifier c = UCIExperiments.setClassifier(classifier);
        Instances all = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem);
        Instances[] split = InstanceTools.resampleInstances(all, fold, propInTrain);
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions/" + problem)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            double acc = UCIExperiments.singleClassifierAndFold(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFold(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        OutFile p = null;
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            if (p == null) {
                throw new Exception(" file wont open!! " + resultsPath + "/testFold" + fold + ".csv");
            }
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method singleClassifierAndFold in class UCIExperiments");
            System.out.println(" Classifier = " + c.getClass().getName());
            System.out.println(" Results path=" + resultsPath);
            System.out.println(" Outfile = " + p);
            System.out.println(" Train Split = " + train.toSummaryString());
            System.out.println(" Test Split = " + test.toSummaryString());
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "UCIContinuous/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            UCIExperiments.singleClassifierAndFold(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "UCI Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] paras = new String[]{"SVM_0ptKernel", "monks-1", "5"};
            UCIExperiments.singleClassifierAndFold(paras);
        }
    }
}

