/*
 * Decompiled with CFR 0.152.
 */
package papers.bagnall17defaultparas;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import papers.Bagnall16bakeoff;
import utilities.ClassifierTools;
import weka.core.Instances;

public class RepoExperiments {
    public static String[] classifiers = new String[]{"HESCA", "RISE", "RISE Repeat"};

    public static void createBaseExperimentScripts(boolean grace) {
        String path = "C:\\Users\\ajb\\Dropbox\\Code\\Cluster Scripts\\RepoScripts\\";
        File f = new File(path);
        int folds = 100;
        int mem = 8000;
        if (!f.isDirectory()) {
            f.mkdir();
        }
        for (String s : classifiers) {
            OutFile of2 = grace ? new OutFile(path + s + "Grace.txt") : new OutFile(path + s + ".txt");
            for (String a : DataSets.fileNames) {
                OutFile of = grace ? new OutFile(path + s + a + "Grace.bsub") : new OutFile(path + s + a + ".bsub");
                of.writeLine("#!/bin/csh");
                if (grace) {
                    of.writeLine("#BSUB -q short");
                } else {
                    of.writeLine("#BSUB -q long-eth");
                }
                of.writeLine("#BSUB -J " + s + a + "[1-" + folds + "]");
                of.writeLine("#BSUB -oo output/" + a + ".out");
                of.writeLine("#BSUB -eo error/" + a + ".err");
                if (grace) {
                    of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                    of.writeLine("#BSUB -M " + mem);
                    of.writeLine(" module add java/jdk/1.8.0_31");
                } else {
                    of.writeLine("#BSUB -R \"rusage[mem=" + (4000 + mem) + "]\"");
                    of.writeLine("#BSUB -M " + (4000 + mem));
                    of.writeLine("module add java/jdk1.8.0_51");
                }
                of.writeLine("java -jar Repo.jar " + s + " " + a + " $LSB_JOBINDEX");
                if (grace) {
                    of2.writeLine("bsub < Scripts/RepoScripts/" + s + a + "Grace.bsub");
                    continue;
                }
                of2.writeLine("bsub < Scripts/RepoScripts/" + s + a + ".bsub");
            }
        }
    }

    public static boolean foldComplete(String path, int fold, int numTrain, int numTest) {
        File f = new File(path + "//testFold" + fold + ".csv");
        File f2 = new File(path + "//trainFold" + fold + ".csv");
        if (!f.exists() || !f2.exists()) {
            return false;
        }
        InFile inf1 = new InFile(path + "//testFold" + fold + ".csv");
        InFile inf2 = new InFile(path + "//testFold" + fold + ".csv");
        int c1 = inf1.countLines();
        int c2 = inf2.countLines();
        return c1 >= 3 && c2 >= 3;
    }

    public static void collateResults(int folds) {
        int i;
        String basePath = "C:\\Research\\Results\\RepoResults\\";
        for (String cls : classifiers) {
            File f = new File(basePath + cls);
            if (!f.isDirectory()) continue;
            OutFile clsResults = new OutFile(basePath + cls + "//" + cls + ".csv");
            OutFile missing = null;
            int missingCount = 0;
            for (int i2 = 0; i2 < DataSets.fileNames.length; ++i2) {
                String name = DataSets.fileNames[i2];
                Instances test = ClassifierTools.loadData(DataSets.problemPath + name + "//" + name + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.problemPath + name + "//" + name + "_TRAIN");
                int testSize = test.numInstances();
                int trainSize = train.numInstances();
                clsResults.writeString(DataSets.fileNames[i2] + ",");
                String path = basePath + cls + "//Predictions//" + DataSets.fileNames[i2];
                if (missing != null && missingCount > 0) {
                    missing.writeString("\n");
                }
                missingCount = 0;
                for (int j = 0; j < folds; ++j) {
                    if (RepoExperiments.foldComplete(path, j, trainSize, testSize)) {
                        InFile inf = new InFile(path + "//testFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        clsResults.writeString(inf.readDouble() + ",");
                        continue;
                    }
                    if (missing == null) {
                        missing = new OutFile(basePath + cls + "//" + cls + "MISSING.csv");
                    }
                    if (missingCount == 0) {
                        missing.writeString(name);
                    }
                    ++missingCount;
                    missing.writeString("," + j);
                }
                clsResults.writeString("\n");
            }
            clsResults.closeFile();
        }
        OutFile acc = new OutFile(basePath + "CombinedAcc.csv");
        OutFile count = new OutFile(basePath + "CombinedCount.csv");
        for (String cls : classifiers) {
            acc.writeString("," + cls);
            count.writeString("," + cls);
        }
        acc.writeString("\n");
        count.writeString("\n");
        InFile[] all = new InFile[classifiers.length];
        for (i = 0; i < all.length; ++i) {
            String p = basePath + classifiers[i] + "//" + classifiers[i] + ".csv";
            all[i] = new File(p).exists() ? new InFile(p) : null;
        }
        for (i = 0; i < DataSets.fileNames.length; ++i) {
            acc.writeString(DataSets.fileNames[i] + ",");
            count.writeString(DataSets.fileNames[i] + ",");
            for (int j = 0; j < all.length; ++j) {
                if (all[j] == null) {
                    acc.writeString(",");
                    count.writeString("0,");
                    continue;
                }
                String[] res = all[j].readLine().split(",");
                count.writeString(res.length - 1 + ",");
                double mean = 0.0;
                for (int k = 1; k < res.length; ++k) {
                    mean += Double.parseDouble(res[k]);
                }
                if (res.length > 1) {
                    acc.writeString(mean / (double)(res.length - 1) + ",");
                    continue;
                }
                acc.writeString(",");
            }
            acc.writeString("\n");
            count.writeString("\n");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String jasonPath = "/gpfs/home/sjx07ngu/";
            DataSets.problemPath = jasonPath + "TSC Problems/";
            DataSets.resultsPath = jasonPath + "Results/RepoExperiments/";
            Bagnall16bakeoff.singleClassifierAndFold(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "TSC Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/RepoExperiments/";
            String[] paras = new String[]{"RISE", "ItalyPowerDemand", "6"};
            Bagnall16bakeoff.singleClassifierAndFold(paras);
        }
    }
}

