/*
 * Decompiled with CFR 0.152.
 */
package papers;

import development.DataSets;
import fileIO.OutFile;
import java.io.File;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.ParameterSplittable;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.CrossValidator;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.CAWPE;
import vector_classifiers.PLSNominalClassifier;
import vector_classifiers.SaveEachParameter;
import weka.attributeSelection.PrincipalComponents;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class Large17ForgedAlcohol {
    public static int folds = 30;
    static int numCVFolds = 10;
    static boolean debug = true;
    static boolean checkpoint = false;
    static boolean generateTrainFiles = true;
    static Integer parameterNum = 0;
    static double trainSplitProportion = 0.7;
    static String loboFolder = "LOBO/";
    static String randBottleFolder = "RandomBottles/";
    static String randForgeryFolder = "RandomForgery/";

    public static Classifier setClassifier(String classifier, int fold) throws Exception {
        AbstractClassifier c = null;
        SMO smo = null;
        switch (classifier) {
            case "1NN": {
                c = new kNN();
                break;
            }
            case "C45": {
                c = new J48();
                break;
            }
            case "PLSNominalClassifier": {
                c = new PLSNominalClassifier();
                break;
            }
            case "SVML": {
                smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                PolyKernel kl = new PolyKernel();
                kl.setExponent(1.0);
                smo.setKernel(kl);
                smo.setRandomSeed(fold);
                c = smo;
                break;
            }
            case "SVMQ": {
                smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                PolyKernel kq = new PolyKernel();
                kq.setExponent(2.0);
                smo.setKernel(kq);
                smo.setRandomSeed(fold);
                c = smo;
                break;
            }
            case "SVMRBF": {
                smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                RBFKernel rbf = new RBFKernel();
                smo.setKernel(rbf);
                smo.setRandomSeed(fold);
                c = smo;
                break;
            }
            case "RandF": {
                RandomForest r = new RandomForest();
                r.setNumTrees(500);
                r.setSeed(fold);
                c = r;
                break;
            }
            case "RotF": {
                RotationForest rf = new RotationForest();
                rf.setNumIterations(50);
                rf.setSeed(fold);
                c = rf;
                break;
            }
            case "MLP": {
                c = new MultilayerPerceptron();
                break;
            }
            case "Logistic": {
                c = new Logistic();
                break;
            }
            case "HESCA": {
                c = new CAWPE();
                ((CAWPE)c).setRandSeed(fold);
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "RISE": {
                c = new RISE();
                break;
            }
            case "BOSS": 
            case "BOSSEnsemble": {
                c = new BOSS();
                break;
            }
            default: {
                throw new Exception("Unknown classifier: " + classifier);
            }
        }
        return c;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Large17ForgedAlcohol.clusterRun(args);
            return;
        }
        Large17ForgedAlcohol.paperExampleCode();
    }

    public static Instances[] sampleFromPredefinedFolds(String problem, int fold) {
        Instances train = ClassifierTools.loadData(problem + fold + "_TRAIN");
        Instances test = ClassifierTools.loadData(problem + fold + "_TEST");
        return new Instances[]{train, test};
    }

    public static Instances[] sampleFromFullDataset(String dataset, int fold, String method) throws Exception {
        Instances data = null;
        Instances[] split = null;
        switch (method) {
            case "LOBO": {
                data = ClassifierTools.loadData(DataSets.problemPath + dataset);
                split = Large17ForgedAlcohol.resampleLOBOFromInstances(data, fold, true);
                break;
            }
            case "LOBOPCA": {
                data = ClassifierTools.loadData(DataSets.problemPath + dataset);
                split = Large17ForgedAlcohol.resampleLOBOFromInstances(data, fold, true);
                PrincipalComponents pca = new PrincipalComponents();
                pca.setVarianceCovered(0.95);
                pca.buildEvaluator(split[0]);
                Instances pcaTrain = pca.transformedData(split[0]);
                Instances pcaTest = new Instances(pca.transformedHeader());
                for (Instance instance : split[1]) {
                    pcaTest.add(pca.convertInstance(instance));
                }
                split = new Instances[]{pcaTrain, pcaTest};
                break;
            }
            case "RandomBottles": {
                data = ClassifierTools.loadData(DataSets.problemPath + dataset);
                split = Large17ForgedAlcohol.resampleBottleClassFromInstances(data, fold);
                break;
            }
            default: {
                System.out.println("Unrecognised sampling method for alcohol dsets, SpectralDataResultsFileBuilder.sample(...): " + method);
                System.exit(0);
            }
        }
        return split;
    }

    public static Instances[] resampleBottleClassFromInstances(Instances all2, int seed) {
        Random rand = new Random(seed);
        Instances allData = new Instances(all2);
        allData.setClassIndex(2);
        Attribute newClassAtt = allData.attribute(0);
        double[] newClassVals = allData.attributeToDoubleArray(0);
        allData.deleteAttributeAt(0);
        allData.deleteAttributeAt(allData.numAttributes() - 1);
        allData.insertAttributeAt(newClassAtt, allData.numAttributes());
        allData.setClassIndex(allData.numAttributes() - 1);
        for (int i = 0; i < allData.numInstances(); ++i) {
            allData.instance(i).setValue(allData.numAttributes() - 1, newClassVals[i]);
        }
        return InstanceTools.resampleInstances(allData, seed, trainSplitProportion);
    }

    public static Instances[] resampleLOBOFromInstances(Instances all2, int seed, boolean removeBottleAtt) {
        Instances all = new Instances(all2);
        TreeSet<Double> bottleSet = new TreeSet<Double>();
        for (Instance inst : all) {
            bottleSet.add(inst.value(0));
        }
        int numBottles = bottleSet.size();
        int samplesPerBottle = all.numInstances() / numBottles;
        double testBottle = seed % numBottles;
        Instances[] data = new Instances[]{new Instances(all, (numBottles - 1) * samplesPerBottle), new Instances(all, samplesPerBottle)};
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            Instance inst = (Instance)iter.next();
            if (inst.value(0) != testBottle) continue;
            data[1].add(inst);
            iter.remove();
        }
        data[0].addAll(all);
        Random rand = new Random(seed);
        data[0].randomize(rand);
        data[1].randomize(rand);
        if (removeBottleAtt) {
            Large17ForgedAlcohol.removeBottleAttribute(data);
        }
        return data;
    }

    public static void removeBottleAttribute(Instances data) {
        if (data.attribute("bottleName") != null) {
            data.deleteAttributeAt(data.attribute("bottleName").index());
        }
    }

    public static void removeBottleAttribute(Instances[] data) {
        if (data[0].attribute("bottleName") != null) {
            data[0].deleteAttributeAt(data[0].attribute("bottleName").index());
        }
        if (data[1].attribute("bottleName") != null) {
            data[1].deleteAttributeAt(data[1].attribute("bottleName").index());
        }
    }

    public static void paperExampleCode() throws Exception {
        System.out.println("Performing Leave-one-bottle-out evaluations for ethanol concentration determination");
        boolean useSavedSplits = true;
        String baseDataPath = "";
        baseDataPath = useSavedSplits ? "Z:/Data/AlcoholForgeryFolds/" : "Z:/Data/AlcoholProblems/AllDataWithBottleAttribute/";
        String[] samplingMethods = new String[]{"LOBO", "LOBOPCA", "RandomBottle"};
        int numFolds = 44;
        String[] classifiers = new String[]{"C45"};
        String[] datasets = new String[]{"AlcoholForgeryEthanol", "AlcoholForgeryMethanol"};
        for (String samplingMethod : samplingMethods) {
            System.out.println("Sampling method: " + samplingMethod);
            String PCAprefix = samplingMethod.contains("PCA") ? "PCA" : "";
            for (String dataset : datasets) {
                System.out.println("\tDataset: " + dataset);
                dataset = PCAprefix + dataset;
                DataSets.problemPath = baseDataPath + dataset + "/";
                for (String classifier : classifiers) {
                    System.out.println("\t\tClassifier: " + classifier);
                    double acc = 0.0;
                    for (int fold = 0; fold < numFolds; ++fold) {
                        Instances[] split = null;
                        split = useSavedSplits ? Large17ForgedAlcohol.sampleFromPredefinedFolds(baseDataPath + samplingMethod + "/" + dataset + "/" + dataset, fold) : Large17ForgedAlcohol.sampleFromFullDataset(dataset, fold, samplingMethod);
                        Classifier c = Large17ForgedAlcohol.setClassifier(classifier, fold);
                        c.buildClassifier(split[0]);
                        double foldAcc = ClassifierTools.accuracy(split[1], c);
                        System.out.println("\t\t\tFold" + fold + " acc: " + foldAcc);
                        acc += foldAcc;
                    }
                    System.out.println("\t\t" + classifier + " average accuracy: " + (acc /= (double)numFolds));
                }
            }
        }
    }

    public static void clusterRun(String[] args) throws Exception {
        String s;
        for (String str : args) {
            System.out.println(str);
        }
        DataSets.problemPath = args[0];
        DataSets.resultsPath = args[1];
        generateTrainFiles = Boolean.parseBoolean(args[2]);
        File f = new File(DataSets.resultsPath);
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        String[] newArgs = new String[3];
        for (int i = 0; i < 3; ++i) {
            newArgs[i] = args[i + 3];
        }
        checkpoint = false;
        if (args.length >= 7 && (s = args[args.length - 1].toLowerCase()).equals("true")) {
            checkpoint = true;
        }
        parameterNum = 0;
        if (args.length >= 8) {
            parameterNum = Integer.parseInt(args[7]);
        }
        System.out.println("Checkpoint =" + checkpoint + " param number =" + parameterNum);
        Large17ForgedAlcohol.singleClassifierAndFoldTrainTestSplit(newArgs);
    }

    public static void singleClassifierAndFoldTrainTestSplit(String[] args) throws Exception {
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        String predictions = DataSets.resultsPath + classifier + "/Predictions/" + problem;
        File f = new File(predictions);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            Classifier c = Large17ForgedAlcohol.setClassifier(classifier, fold);
            Instances[] data = Large17ForgedAlcohol.sampleFromPredefinedFolds(DataSets.problemPath + problem + "/" + problem, fold);
            if (c instanceof PLSNominalClassifier && data[0].numAttributes() < ((PLSNominalClassifier)c).getNumComponents()) {
                ((PLSNominalClassifier)c).setNumComponents(data[0].numAttributes() - 1);
            }
            if (parameterNum > 0 && c instanceof ParameterSplittable) {
                checkpoint = false;
                f = new File(predictions + "/fold" + fold + "_" + parameterNum + ".csv");
                if (f.exists() && f.length() > 0L) {
                    System.out.println("Fold " + predictions + "/fold" + fold + "_" + parameterNum + ".csv  already exists");
                    return;
                }
            }
            double acc = Large17ForgedAlcohol.singleClassifierAndFoldTrainTestSplit(data[0], data[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFoldTrainTestSplit(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        String testFoldPath = "/testFold" + fold + ".csv";
        String trainFoldPath = "/trainFold" + fold + ".csv";
        ClassifierResults trainResults = null;
        ClassifierResults testResults = null;
        if (parameterNum > 0 && c instanceof ParameterSplittable) {
            checkpoint = false;
            ((ParameterSplittable)((Object)c)).setParametersFromIndex(parameterNum);
            testFoldPath = "/fold" + fold + "_" + parameterNum + ".csv";
            generateTrainFiles = false;
        } else {
            if (c instanceof SaveableEnsemble) {
                ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
            }
            if (checkpoint && c instanceof SaveEachParameter) {
                ((SaveEachParameter)((Object)c)).setPathToSaveParameters(resultsPath + "/fold" + fold + "_");
            }
        }
        try {
            if (generateTrainFiles) {
                if (c instanceof TrainAccuracyEstimate) {
                    ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(resultsPath + trainFoldPath);
                } else {
                    int numFolds = Math.min(train.numInstances(), numCVFolds);
                    CrossValidator cv = new CrossValidator();
                    cv.setSeed(fold);
                    cv.setNumFolds(numFolds);
                    trainResults = cv.crossValidateWithStats(c, train);
                }
            }
            long buildTime = System.currentTimeMillis();
            c.buildClassifier(train);
            buildTime = System.currentTimeMillis() - buildTime;
            if (generateTrainFiles && !(c instanceof TrainAccuracyEstimate)) {
                OutFile trainOut = new OutFile(resultsPath + trainFoldPath);
                trainOut.writeLine(train.relationName() + "," + c.getClass().getName() + ",train");
                if (c instanceof SaveParameterInfo) {
                    trainOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
                } else {
                    trainOut.writeLine("BuildTime," + buildTime + ",No Parameter Info");
                }
                trainOut.writeLine(trainResults.acc + "");
                trainOut.writeLine(trainResults.writeInstancePredictions());
                trainOut.closeFile();
            }
            int numInsts = test.numInstances();
            testResults = new ClassifierResults(test.numClasses());
            double[] trueClassValues = test.attributeToDoubleArray(test.classIndex());
            for (int testInstIndex = 0; testInstIndex < numInsts; ++testInstIndex) {
                test.instance(testInstIndex).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(testInstIndex));
                testResults.storeSingleResult(probs);
            }
            testResults.finaliseResults(trueClassValues);
            OutFile testOut = new OutFile(resultsPath + testFoldPath);
            testOut.writeLine(test.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                testOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                testOut.writeLine("No parameter info");
            }
            testOut.writeLine(testResults.acc + "");
            testOut.writeString(testResults.writeInstancePredictions());
            testOut.closeFile();
            return testResults.acc;
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            return Double.NaN;
        }
    }
}

