/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import multivariate_timeseriesweka.classifiers.ConcatenateClassifier;
import multivariate_timeseriesweka.classifiers.NN_DTW_A;
import multivariate_timeseriesweka.classifiers.NN_DTW_D;
import multivariate_timeseriesweka.classifiers.NN_DTW_I;
import multivariate_timeseriesweka.classifiers.NN_ED_D;
import multivariate_timeseriesweka.classifiers.NN_ED_I;
import multivariate_timeseriesweka.ensembles.IndependentDimensionEnsemble;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import weka.classifiers.Classifier;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.RandomForest;

public class DefaultClassifiers {
    public static final Map<String, Supplier<Classifier>> CLASSIFIERS;

    public static Classifier createDTW_A() {
        NN_DTW_A A = new NN_DTW_A();
        A.setR(0.2);
        return A;
    }

    public static Classifier createDTW_I() {
        NN_DTW_I nn = new NN_DTW_I();
        nn.setR(0.2);
        return nn;
    }

    public static Classifier createDTW_D() {
        NN_DTW_D nn = new NN_DTW_D();
        nn.setR(0.2);
        return nn;
    }

    public static Classifier createED_I() {
        return new NN_ED_I();
    }

    public static Classifier createED_D() {
        return new NN_ED_D();
    }

    public static Classifier createRotationForest() {
        RotationForest rf = new RotationForest();
        rf.setNumIterations(50);
        IndependentDimensionEnsemble c = new IndependentDimensionEnsemble(rf);
        return c;
    }

    public static Classifier createRandomForest() {
        RandomForest rf = new RandomForest();
        rf.setNumTrees(500);
        IndependentDimensionEnsemble c = new IndependentDimensionEnsemble(rf);
        return c;
    }

    public static Classifier create1NNDTW() {
        DTW1NN nn = new DTW1NN();
        IndependentDimensionEnsemble c = new IndependentDimensionEnsemble(nn);
        return c;
    }

    public static Classifier createMultilayerPerceptron() {
        MultilayerPerceptron mlp = new MultilayerPerceptron();
        IndependentDimensionEnsemble c = new IndependentDimensionEnsemble(mlp);
        return c;
    }

    public static Classifier createSMO() {
        SMO svmq = new SMO();
        svmq.turnChecksOff();
        PolyKernel kq = new PolyKernel();
        kq.setExponent(2.0);
        svmq.setKernel(kq);
        IndependentDimensionEnsemble c = new IndependentDimensionEnsemble(svmq);
        return c;
    }

    public static Classifier createRotationForest_concat() {
        RotationForest rf = new RotationForest();
        rf.setNumIterations(50);
        ConcatenateClassifier c = new ConcatenateClassifier(rf);
        return c;
    }

    public static Classifier createRandomForest_concat() {
        RandomForest rf = new RandomForest();
        rf.setNumTrees(500);
        ConcatenateClassifier c = new ConcatenateClassifier(rf);
        return c;
    }

    public static Classifier create1NNDTW_concat() {
        DTW1NN nn = new DTW1NN();
        ConcatenateClassifier c = new ConcatenateClassifier(nn);
        return c;
    }

    public static Classifier createMultilayerPerceptron_concat() {
        MultilayerPerceptron mlp = new MultilayerPerceptron();
        ConcatenateClassifier c = new ConcatenateClassifier(mlp);
        return c;
    }

    public static Classifier createSMO_concat() {
        SMO svmq = new SMO();
        svmq.turnChecksOff();
        PolyKernel kq = new PolyKernel();
        kq.setExponent(2.0);
        svmq.setKernel(kq);
        ConcatenateClassifier c = new ConcatenateClassifier(svmq);
        return c;
    }

    public static Classifier createST_concat() {
        return new ConcatenateClassifier(new ST_HESCA());
    }

    static {
        HashMap<String, Supplier<Classifier>> map = new HashMap<String, Supplier<Classifier>>();
        map.put("DTW_A", DefaultClassifiers::createDTW_A);
        map.put("DTW_D", DefaultClassifiers::createDTW_D);
        map.put("DTW_I", DefaultClassifiers::createDTW_I);
        map.put("ED_I", DefaultClassifiers::createED_D);
        map.put("ED_D", DefaultClassifiers::createED_I);
        map.put("RotationForest", DefaultClassifiers::createRotationForest);
        map.put("RandomForest", DefaultClassifiers::createRandomForest);
        map.put("1NN_DTW", DefaultClassifiers::create1NNDTW);
        map.put("MLP", DefaultClassifiers::createMultilayerPerceptron);
        map.put("SMO", DefaultClassifiers::createSMO);
        map.put("RotationForest_concat", DefaultClassifiers::createRotationForest_concat);
        map.put("RandomForest_concat", DefaultClassifiers::createRandomForest_concat);
        map.put("1NN_DTW_concat", DefaultClassifiers::create1NNDTW_concat);
        map.put("MLP_concat", DefaultClassifiers::createMultilayerPerceptron_concat);
        map.put("SMO_concat", DefaultClassifiers::createSMO_concat);
        map.put("ST_concat", DefaultClassifiers::createST_concat);
        CLASSIFIERS = Collections.unmodifiableMap(map);
    }
}

