/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import multivariate_timeseriesweka.classifiers.ConcatenateClassifier;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.ST_HESCA;

public class ConcatenationClassifiers {
    public static final Map<String, Supplier<ConcatenateClassifier>> CONCAT_CLASSIFIERS;

    public static ConcatenateClassifier createST_HESCA_concat() {
        ST_HESCA st = new ST_HESCA();
        st.setDayLimit(1);
        return new ConcatenateClassifier(st);
    }

    public static ConcatenateClassifier createBOSS_concat() {
        return new ConcatenateClassifier(new BOSS());
    }

    public static ConcatenateClassifier createEE_concat() {
        return new ConcatenateClassifier(new ElasticEnsemble());
    }

    public static ConcatenateClassifier createLS_concat() {
        return new ConcatenateClassifier(new LearnShapelets());
    }

    static {
        HashMap<String, Supplier<ConcatenateClassifier>> map = new HashMap<String, Supplier<ConcatenateClassifier>>();
        map.put("ST_HESCA", ConcatenationClassifiers::createST_HESCA_concat);
        map.put("BOSS", ConcatenationClassifiers::createBOSS_concat);
        map.put("EE", ConcatenationClassifiers::createEE_concat);
        map.put("LS", ConcatenationClassifiers::createLS_concat);
        CONCAT_CLASSIFIERS = Collections.unmodifiableMap(map);
    }
}

