/*
 * Decompiled with CFR 0.152.
 */
package fileIO;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class OutFile {
    private FileWriter fw;
    private BufferedWriter bw;
    private PrintWriter outFile;
    private char delimit;

    public OutFile(String name) {
        try {
            this.fw = new FileWriter(name);
            this.bw = new BufferedWriter(this.fw);
            this.outFile = new PrintWriter(this.fw);
            this.delimit = (char)32;
        }
        catch (IOException exception) {
            System.err.println(exception + " File " + name + " Not found");
        }
    }

    public OutFile(String name, char delimiter) {
        try {
            this.fw = new FileWriter(name);
            this.bw = new BufferedWriter(this.fw);
            this.outFile = new PrintWriter(this.fw);
            this.delimit = delimiter;
        }
        catch (IOException exception) {
            System.out.println(" File " + name + " Not found");
        }
    }

    public OutFile(String name, boolean append) {
        try {
            this.fw = new FileWriter(name, append);
            this.bw = new BufferedWriter(this.fw);
            this.outFile = new PrintWriter(this.fw);
            this.delimit = (char)32;
        }
        catch (IOException exception) {
            System.out.println(" File " + name + " Not found");
        }
    }

    public boolean writeString(String v) {
        this.outFile.print(v);
        return !this.outFile.checkError();
    }

    public boolean writeLine(String v) {
        this.outFile.print(v + "\n");
        return !this.outFile.checkError();
    }

    public boolean writeInt(int v) {
        this.outFile.print("" + v + this.delimit);
        return !this.outFile.checkError();
    }

    public boolean writeChar(char c) {
        this.outFile.print(c);
        return !this.outFile.checkError();
    }

    public boolean writeBoolean(boolean b) {
        this.outFile.print(b);
        return !this.outFile.checkError();
    }

    public boolean writeDouble(double v) {
        this.outFile.print("" + v + this.delimit);
        return !this.outFile.checkError();
    }

    public boolean newLine() {
        this.outFile.print("\n");
        return !this.outFile.checkError();
    }

    public void closeFile() {
        this.outFile.close();
    }
}

