/*
 * Decompiled with CFR 0.152.
 */
package development;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.FFT;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.trees.RandomTree;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class RiseV2
implements Classifier {
    private Random random = null;
    private Classifier baseClassifier = null;
    private Classifier[] baseClassifiers = null;
    private int[][] startEndPoints = null;
    private int numClassifiers = 0;
    private int interval = 0;
    private String relationName = null;
    private Filter filter;
    private FFT fft;
    private long seed = 0L;
    private Boolean buildFromSavedData;
    private Instances testInstances = null;
    private int testClassificationIndex = 0;
    private int minimumIntervalLength = 2;
    private int maximumIntervalLength = 50;

    public RiseV2(Long seed) {
        this.seed = seed;
        this.random = new Random(seed);
        this.initialise();
    }

    public RiseV2() {
        this.random = new Random();
        this.initialise();
    }

    private void initialise() {
        this.numClassifiers = 50;
        this.setBaseClassifier();
        this.filter = Filter.PS;
        this.fft = new FFT();
        this.startEndPoints = new int[this.numClassifiers][2];
        this.buildFromSavedData = false;
    }

    private void setBaseClassifier() {
        this.baseClassifier = new RandomTree();
    }

    public void setBaseClassifier(Classifier classifier) {
        this.baseClassifier = classifier;
    }

    public void setMinimumIntervalLength(int length) {
        this.minimumIntervalLength = length;
    }

    public void setMaximumIntervalLength(int length) {
        this.maximumIntervalLength = length;
    }

    public void setNumClassifiers(int numClassifiers) {
        this.numClassifiers = numClassifiers;
        this.startEndPoints = new int[numClassifiers][2];
    }

    public void buildFromSavedData(Boolean buildFromSavedData) {
        this.buildFromSavedData = buildFromSavedData;
    }

    public boolean getBuildFromSavedData() {
        return this.buildFromSavedData;
    }

    public void setTransformType(String s) {
        String str;
        switch (str = s.toUpperCase()) {
            case "ACF": 
            case "AFC": 
            case "AUTOCORRELATION": {
                this.filter = Filter.ACF;
                break;
            }
            case "PS": 
            case "POWERSPECTRUM": {
                this.filter = Filter.PS;
                break;
            }
            case "PS_ACF": 
            case "ACF_PS": 
            case "BOTH": {
                this.filter = Filter.PS_ACF;
            }
        }
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.maximumIntervalLength > data.get(0).numAttributes() - 1 || this.maximumIntervalLength <= 0) {
            this.maximumIntervalLength = data.get(0).numAttributes() - 1;
        }
        if (this.minimumIntervalLength >= data.get(0).numAttributes() - 1 || this.minimumIntervalLength <= 0) {
            this.minimumIntervalLength = 2;
        }
        this.testClassificationIndex = 0;
        this.baseClassifiers = new Classifier[this.numClassifiers];
        if (!this.buildFromSavedData.booleanValue()) {
            this.initialiseStartEndArray(data);
        }
        for (int i = 0; i < this.numClassifiers; ++i) {
            Instances intervalInstances = null;
            intervalInstances = this.buildFromSavedData == false ? this.produceIntervalInstances(data, i) : ClassifierTools.loadData("RISE/Training Data/Fold " + (int)this.seed + "/Classifier " + i);
            this.baseClassifiers[i] = AbstractClassifier.makeCopy(this.baseClassifier);
            this.baseClassifiers[i].buildClassifier(intervalInstances);
        }
    }

    private void initialiseStartEndArray(Instances instances) {
        for (int i = 0; i < this.numClassifiers; ++i) {
            do {
                this.startEndPoints[i][0] = this.random.nextInt(instances.numAttributes() - 1);
                this.startEndPoints[i][1] = this.random.nextInt(instances.numAttributes() - this.startEndPoints[i][0]) + this.startEndPoints[i][0];
                this.interval = this.startEndPoints[i][1] - this.startEndPoints[i][0];
            } while (this.interval < this.minimumIntervalLength || this.interval > this.maximumIntervalLength);
        }
    }

    private Instances produceTransform(Instances instances) {
        Instances temp = null;
        switch (this.filter) {
            case ACF: {
                temp = ACF.formChangeCombo(instances);
                break;
            }
            case PS: {
                try {
                    this.fft.useFFT();
                    temp = this.fft.process(instances);
                }
                catch (Exception ex) {
                    Logger.getLogger(RiseV2.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case PS_ACF: {
                temp = this.combinedPSACF(instances);
            }
        }
        return temp;
    }

    private Instances combinedPSACF(Instances instances) {
        Instances combo = ACF.formChangeCombo(instances);
        Instances temp = null;
        try {
            temp = this.fft.process(instances);
        }
        catch (Exception ex) {
            Logger.getLogger(RiseV2.class.getName()).log(Level.SEVERE, null, ex);
        }
        combo.setClassIndex(-1);
        combo.deleteAttributeAt(combo.numAttributes() - 1);
        combo = Instances.mergeInstances(combo, temp);
        combo.setClassIndex(combo.numAttributes() - 1);
        return combo;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] distribution = this.distributionForInstance(instance);
        int maxVote = 0;
        for (int i = 1; i < distribution.length; ++i) {
            if (!(distribution[i] > distribution[maxVote])) continue;
            maxVote = i;
        }
        return maxVote;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        double[] distribution = new double[instance.numClasses()];
        for (i = 0; i < this.numClassifiers; ++i) {
            int classVal = 0;
            if (!this.buildFromSavedData.booleanValue()) {
                classVal = (int)this.baseClassifiers[i].classifyInstance(this.produceIntervalInstance(instance, i));
            } else {
                this.testInstances = ClassifierTools.loadData("RISE/Test Data/Fold " + (int)this.seed + "/Classifier " + i);
                classVal = (int)this.baseClassifiers[i].classifyInstance(this.testInstances.get(this.testClassificationIndex));
            }
            int n = classVal;
            distribution[n] = distribution[n] + 1.0;
        }
        i = 0;
        while (i < distribution.length) {
            int n = i++;
            distribution[n] = distribution[n] / (double)this.baseClassifiers.length;
        }
        if (this.buildFromSavedData.booleanValue()) {
            ++this.testClassificationIndex;
        }
        return distribution;
    }

    private Instance produceIntervalInstance(Instance instance, int classifierNum) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < instance.numAttributes(); ++i) {
            attributes.add(instance.attribute(i));
        }
        Instances intervalInstances = new Instances(this.relationName, attributes, 1);
        intervalInstances.add(instance);
        intervalInstances.setClassIndex(instance.numAttributes() - 1);
        intervalInstances = this.produceIntervalInstances(intervalInstances, classifierNum);
        return intervalInstances.firstInstance();
    }

    private Instances produceIntervalInstances(Instances instances, int classifierNum) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = this.startEndPoints[classifierNum][0]; i < this.startEndPoints[classifierNum][1]; ++i) {
            attributes.add(instances.attribute(i));
        }
        attributes.add(instances.attribute(instances.numAttributes() - 1));
        this.relationName = instances.relationName();
        Instances intervalInstances = new Instances(this.relationName, attributes, instances.size());
        for (int i = 0; i < instances.size(); ++i) {
            double[] temp = Arrays.copyOfRange(instances.get(i).toDoubleArray(), this.startEndPoints[classifierNum][0], this.startEndPoints[classifierNum][1] + 1);
            DenseInstance instance = new DenseInstance(temp.length);
            instance.replaceMissingValues(temp);
            instance.setValue(temp.length - 1, instances.get(i).classValue());
            intervalInstances.add(instance);
        }
        intervalInstances.setClassIndex(intervalInstances.numAttributes() - 1);
        intervalInstances = this.produceTransform(intervalInstances);
        return intervalInstances;
    }

    public void createIntervalInstancesARFF(Instances training, Instances test) {
        this.initialiseStartEndArray(training);
        for (int i = 0; i < this.numClassifiers; ++i) {
            if (!new File("RISE/Training Data/Fold " + (int)this.seed + "/Classifier " + i + ".arff").isFile()) {
                ClassifierTools.saveDataset(this.produceIntervalInstances(training, i), "RISE/Training Data/Fold " + (int)this.seed + "/Classifier " + i);
            }
            if (new File("RISE/Test Data/Fold " + (int)this.seed + "/Classifier " + i + ".arff").isFile()) continue;
            ClassifierTools.saveDataset(this.produceIntervalInstances(test, i), "RISE/Test Data/Fold " + (int)this.seed + "/Classifier " + i);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        Instances all = ClassifierTools.loadData("/gpfs/home/cjr13geu/Datasets/MosquitoDatasets/Unaltered/Time/Time.arff");
        RiseV2 rise = new RiseV2((long)Integer.parseInt(args[0]) - 1L);
        Instances[] instances = InstanceTools.resampleInstances(all, Integer.parseInt(args[0]) - 1, 0.5);
        rise.createIntervalInstancesARFF(instances[0], instances[1]);
    }

    private static enum Filter {
        PS,
        ACF,
        FFT,
        PS_ACF;

    }
}

