/*
 * Decompiled with CFR 0.152.
 */
package development;

import fileIO.InFile;
import fileIO.OutFile;
import java.io.PrintStream;
import java.text.DecimalFormat;
import statistics.tests.OneSampleTests;

public class MultipleClassifiersPairwiseTest {
    public static boolean beQuiet = false;
    static double[][] accs;
    static double[][] pValsTTest;
    static double[][] pValsSignTest;
    static double[][] pValsSignRankTest;
    static double[][] bonferonni_pVals;
    static boolean[][] noDifference;
    static int nosClassifiers;
    static int nosProblems;
    static String[] names;

    public static void loadData(String file, PrintStream out) {
        InFile data = new InFile(file);
        nosProblems = data.countLines() - 1;
        data = new InFile(file);
        String[] temp = data.readLine().split(",");
        nosClassifiers = temp.length - 1;
        names = new String[nosClassifiers];
        for (int i = 0; i < nosClassifiers; ++i) {
            MultipleClassifiersPairwiseTest.names[i] = temp[i + 1];
        }
        accs = new double[nosClassifiers][nosProblems];
        for (int j = 0; j < nosProblems; ++j) {
            String[] line = data.readLine().split(",");
            if (!beQuiet) {
                System.out.print("Problem =" + line[0] + ",");
            }
            for (int i = 0; i < nosClassifiers; ++i) {
                MultipleClassifiersPairwiseTest.accs[i][j] = Double.parseDouble(line[i + 1]);
                if (beQuiet) continue;
                out.print(accs[i][j] + ",");
            }
            if (beQuiet) continue;
            out.print("\n");
        }
    }

    public static void loadData(String file) {
        MultipleClassifiersPairwiseTest.loadData(file, System.out);
    }

    public static void findPVals() {
        pValsTTest = new double[nosClassifiers][nosClassifiers];
        pValsSignTest = new double[nosClassifiers][nosClassifiers];
        pValsSignRankTest = new double[nosClassifiers][nosClassifiers];
        OneSampleTests test = new OneSampleTests();
        for (int i = 0; i < nosClassifiers; ++i) {
            for (int j = i + 1; j < nosClassifiers; ++j) {
                double[] diff = new double[accs[i].length];
                for (int k = 0; k < accs[i].length; ++k) {
                    diff[k] = accs[i][k] - accs[j][k];
                }
                String str = test.performTests(diff);
                String[] tmp = str.split(",");
                MultipleClassifiersPairwiseTest.pValsTTest[i][j] = Double.parseDouble(tmp[2]);
                MultipleClassifiersPairwiseTest.pValsSignTest[i][j] = Double.parseDouble(tmp[5]);
                MultipleClassifiersPairwiseTest.pValsSignRankTest[i][j] = Double.parseDouble(tmp[8]);
            }
        }
    }

    public static void findMeanDifferences(String file) {
        int j;
        int i;
        double[][] meanDiff = new double[nosClassifiers][nosClassifiers];
        OutFile outf = new OutFile(file);
        for (i = 0; i < nosClassifiers; ++i) {
            for (j = i + 1; j < nosClassifiers; ++j) {
                for (int k = 0; k < accs[i].length; ++k) {
                    double[] dArray = meanDiff[i];
                    int n = j;
                    dArray[n] = dArray[n] + (accs[i][k] - accs[j][k]);
                }
                double[] dArray = meanDiff[i];
                int n = j;
                dArray[n] = dArray[n] / (double)accs[i].length;
                meanDiff[j][i] = -meanDiff[i][j];
            }
        }
        for (i = 0; i < nosClassifiers; ++i) {
            for (j = 0; j < nosClassifiers; ++j) {
                outf.writeString(meanDiff[i][j] + ",");
            }
            outf.writeString("\n");
        }
    }

    public static void findDifferences(double alpha, boolean printPVals) {
        noDifference = new boolean[nosClassifiers][nosClassifiers];
        for (int i = 0; i < nosClassifiers; ++i) {
            MultipleClassifiersPairwiseTest.noDifference[i][i] = true;
            for (int j = i + 1; j < nosClassifiers; ++j) {
                MultipleClassifiersPairwiseTest.noDifference[i][j] = true;
                MultipleClassifiersPairwiseTest.noDifference[j][i] = true;
                if (!(pValsSignRankTest[i][j] < alpha)) continue;
                MultipleClassifiersPairwiseTest.noDifference[i][j] = false;
                MultipleClassifiersPairwiseTest.noDifference[j][i] = false;
            }
        }
        DecimalFormat df = new DecimalFormat("##.#####");
    }

    public static void runTests(String input, String output) {
        MultipleClassifiersPairwiseTest.loadData(input);
        MultipleClassifiersPairwiseTest.findPVals();
        double alpha = 0.1;
        MultipleClassifiersPairwiseTest.findDifferences(alpha /= (double)(nosClassifiers - 1), true);
        OutFile cliques = new OutFile(output);
        for (int i = 0; i < nosClassifiers; ++i) {
            for (int j = 0; j < nosClassifiers; ++j) {
                cliques.writeString(noDifference[i][j] + ",");
            }
            cliques.writeString("\n");
        }
    }

    public static StringBuilder runTests(double[][] d, String[] n) {
        int j;
        int i;
        nosProblems = d.length;
        nosClassifiers = d[0].length;
        names = n;
        accs = d;
        MultipleClassifiersPairwiseTest.findPVals();
        double alpha = 0.05;
        MultipleClassifiersPairwiseTest.findDifferences(alpha /= (double)(nosClassifiers - 1), true);
        StringBuilder results = new StringBuilder();
        results.append("T TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(",").append(names[i]);
        }
        results.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                results.append(",").append(pValsTTest[i][j]);
            }
            results.append("\n");
        }
        results.append("\n");
        results.append("SIGN TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(",").append(names[i]);
        }
        results.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                results.append(",").append(pValsSignTest[i][j]);
            }
            results.append("\n");
        }
        results.append("\n");
        results.append("SIGN RANK TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(",").append(names[i]);
        }
        results.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                results.append(",").append(pValsSignRankTest[i][j]);
            }
            results.append("\n");
        }
        results.append("\n");
        results.append("NOSIGDIFFERENCE");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(",").append(names[i]);
        }
        results.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                results.append(",").append(noDifference[i][j]);
            }
            results.append("\n");
        }
        return results;
    }

    public static StringBuilder runSignRankTest(double[][] d, String[] n) {
        int i;
        nosProblems = d.length;
        nosClassifiers = d[0].length;
        names = n;
        accs = d;
        MultipleClassifiersPairwiseTest.findPVals();
        double alpha = 0.05;
        MultipleClassifiersPairwiseTest.findDifferences(alpha /= (double)(nosClassifiers - 1), true);
        StringBuilder results = new StringBuilder();
        results.append("SIGN RANK TEST \n ");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(",").append(names[i]);
        }
        results.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            results.append(names[i]);
            for (int j = 0; j < nosClassifiers; ++j) {
                results.append(",").append(pValsSignRankTest[i][j]);
            }
            results.append("\n");
        }
        return results;
    }

    public static StringBuilder runTests(String input) {
        int j;
        int i;
        MultipleClassifiersPairwiseTest.loadData(input);
        MultipleClassifiersPairwiseTest.findPVals();
        double alpha = 0.1;
        MultipleClassifiersPairwiseTest.findDifferences(alpha /= (double)(nosClassifiers - 1), true);
        StringBuilder cliques = new StringBuilder();
        cliques.append("T TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(",").append(names[i]);
        }
        cliques.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                cliques.append(",").append(pValsTTest[i][j]);
            }
            cliques.append("\n");
        }
        cliques.append("\n");
        cliques.append("SIGN TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(",").append(names[i]);
        }
        cliques.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                cliques.append(",").append(pValsSignTest[i][j]);
            }
            cliques.append("\n");
        }
        cliques.append("\n");
        cliques.append("SIGN RANK TEST");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(",").append(names[i]);
        }
        cliques.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                cliques.append(",").append(pValsSignRankTest[i][j]);
            }
            cliques.append("\n");
        }
        cliques.append("\n");
        cliques.append("NOSIGDIFFERENCE");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(",").append(names[i]);
        }
        cliques.append("\n");
        for (i = 0; i < nosClassifiers; ++i) {
            cliques.append(names[i]);
            for (j = 0; j < nosClassifiers; ++j) {
                cliques.append(",").append(noDifference[i][j]);
            }
            cliques.append("\n");
        }
        return cliques;
    }

    public static String printCliques() {
        StringBuilder sb = new StringBuilder();
        sb.append("cliques = [");
        boolean[][] cliques = MultipleClassifiersPairwiseTest.findCliques(noDifference);
        for (int i = 0; i < cliques.length; ++i) {
            for (int j = 0; j < cliques[i].length; ++j) {
                sb.append(cliques[i][j] ? "1" : Integer.valueOf(0)).append(" ");
            }
            sb.append("\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public static boolean[][] findCliques(boolean[][] same) {
        boolean[][] cliques = new boolean[same.length][];
        for (int i = 0; i < same.length; ++i) {
            boolean[] clique = new boolean[same.length];
            boolean inClique = false;
            for (int j = i + 1; j < same[i].length; ++j) {
                inClique = inClique || same[i][j];
                clique[j] = same[i][j];
            }
            clique[i] = true;
            if (!inClique || MultipleClassifiersPairwiseTest.isSubClique(cliques, clique)) continue;
            MultipleClassifiersPairwiseTest.addClique(cliques, clique);
        }
        int numNull = 0;
        for (int i = cliques.length - 1; i >= 0 && cliques[i] == null; --i) {
            ++numNull;
        }
        boolean[][] finalCliques = new boolean[cliques.length - numNull][];
        System.arraycopy(cliques, 0, finalCliques, 0, finalCliques.length);
        return finalCliques;
    }

    public static void addClique(boolean[][] cliques, boolean[] newClique) {
        for (int i = 0; i < cliques.length; ++i) {
            if (cliques[i] != null) continue;
            cliques[i] = newClique;
            break;
        }
    }

    public static boolean isSubClique(boolean[][] cliques, boolean[] newClique) {
        for (int i = 0; i < cliques.length && cliques[i] != null; ++i) {
            boolean subOfThisClique = true;
            for (int j = 0; j < cliques[i].length; ++j) {
                if (!newClique[j] || cliques[i][j]) continue;
                subOfThisClique = false;
            }
            if (!subOfThisClique) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String input = "C:\\Users\\ajb\\Dropbox\\For Eamonn\\MPvsBenchmark.csv";
        System.out.println(MultipleClassifiersPairwiseTest.runTests(input).toString());
        System.out.println("\n\n" + MultipleClassifiersPairwiseTest.printCliques());
    }
}

