/*
 * Decompiled with CFR 0.152.
 */
package development;

import ResultsProcessing.MatlabController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import utilities.ClassifierResults;
import utilities.ClassifierResultsAnalysis;
import utilities.DebugPrinting;
import utilities.ErrorReport;
import utilities.generic_storage.Pair;

public class MultipleClassifierEvaluation
implements DebugPrinting {
    private String writePath;
    private String experimentName;
    private List<String> datasets;
    private Map<String, Map<String, String[]>> datasetGroupings;
    private Map<String, ClassifierResults[][][]> classifiersResults;
    private int numFolds;
    private ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics;
    private boolean buildMatlabDiagrams;
    private boolean cleanResults;
    private boolean testResultsOnly;
    private boolean performPostHocDsetResultsClustering;

    public MultipleClassifierEvaluation(String writePath, String experimentName, int numFolds) {
        this.writePath = writePath;
        this.experimentName = experimentName;
        this.numFolds = numFolds;
        this.buildMatlabDiagrams = false;
        this.cleanResults = true;
        this.testResultsOnly = true;
        this.performPostHocDsetResultsClustering = false;
        this.datasets = new ArrayList<String>();
        this.datasetGroupings = new HashMap<String, Map<String, String[]>>();
        this.classifiersResults = new HashMap<String, ClassifierResults[][][]>();
        this.statistics = ClassifierResultsAnalysis.getDefaultStatistics();
    }

    public MultipleClassifierEvaluation setTestResultsOnly(boolean b) {
        this.testResultsOnly = b;
        return this;
    }

    public MultipleClassifierEvaluation setBuildMatlabDiagrams(boolean b) {
        this.buildMatlabDiagrams = b;
        return this;
    }

    public MultipleClassifierEvaluation setCleanResults(boolean b) {
        this.cleanResults = b;
        return this;
    }

    public MultipleClassifierEvaluation setPerformPostHocDsetResultsClustering(boolean b) {
        this.performPostHocDsetResultsClustering = b;
        return this;
    }

    public MultipleClassifierEvaluation setDatasets(String datasetListFilename) throws FileNotFoundException {
        Scanner filein = new Scanner(new File(datasetListFilename));
        ArrayList<String> dsets = new ArrayList<String>();
        while (filein.hasNextLine()) {
            dsets.add(filein.nextLine());
        }
        return this.setDatasets(dsets);
    }

    public MultipleClassifierEvaluation setDatasets(List<String> datasets) {
        this.datasets = datasets;
        return this;
    }

    public MultipleClassifierEvaluation setDatasets(String[] datasets) {
        this.datasets = Arrays.asList(datasets);
        return this;
    }

    public MultipleClassifierEvaluation addDataset(String dataset) {
        this.datasets.add(dataset);
        return this;
    }

    public MultipleClassifierEvaluation removeDataset(String dataset) {
        this.datasets.remove(dataset);
        return this;
    }

    public MultipleClassifierEvaluation clearDatasets() {
        this.datasets.clear();
        return this;
    }

    public MultipleClassifierEvaluation setDatasetGroupingFromDirectory(String groupingDirectory) throws FileNotFoundException {
        this.setDatasetGroupingFromDirectory(groupingDirectory, new File(groupingDirectory).getName());
        return this;
    }

    public MultipleClassifierEvaluation setDatasetGroupingFromDirectory(String groupingDirectory, String customGroupingMethodName) throws FileNotFoundException {
        this.clearDatasetGroupings();
        this.addDatasetGroupingFromDirectory(groupingDirectory, customGroupingMethodName);
        return this;
    }

    public MultipleClassifierEvaluation addAllDatasetGroupingsInDirectory(String groupingSuperDirectory) throws FileNotFoundException {
        for (String groupingDirectory : new File(groupingSuperDirectory).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory();
            }
        })) {
            this.addDatasetGroupingFromDirectory(groupingSuperDirectory + groupingDirectory);
        }
        return this;
    }

    public MultipleClassifierEvaluation addDatasetGroupingFromDirectory(String groupingDirectory) throws FileNotFoundException {
        this.addDatasetGroupingFromDirectory(groupingDirectory, new File(groupingDirectory).getName());
        return this;
    }

    public MultipleClassifierEvaluation addDatasetGroupingFromDirectory(String groupingDirectory, String customGroupingMethodName) throws FileNotFoundException {
        File[] groups = new File(groupingDirectory).listFiles();
        String[] groupNames = new String[groups.length];
        String[][] dsets = new String[groups.length][];
        for (int i = 0; i < groups.length; ++i) {
            groupNames[i] = groups[i].getName().replace(".txt", "").replace(".csv", "");
            Scanner filein = new Scanner(groups[i]);
            ArrayList<String> groupDsets = new ArrayList<String>();
            while (filein.hasNextLine()) {
                groupDsets.add(filein.nextLine());
            }
            dsets[i] = groupDsets.toArray(new String[0]);
        }
        this.addDatasetGrouping(customGroupingMethodName, groupNames, dsets);
        return this;
    }

    public MultipleClassifierEvaluation setDatasetGrouping(String groupingMethodName, String[] groupNames, String[][] groups) {
        this.clearDatasetGroupings();
        this.addDatasetGrouping(groupingMethodName, groupNames, groups);
        return this;
    }

    public MultipleClassifierEvaluation addDatasetGrouping(String groupingMethodName, String[] groupNames, String[][] groups) {
        HashMap<String, String[]> groupsMap = new HashMap<String, String[]>();
        for (int i = 0; i < groupNames.length; ++i) {
            groupsMap.put(groupNames[i], groups[i]);
        }
        this.datasetGroupings.put(groupingMethodName, groupsMap);
        return this;
    }

    public MultipleClassifierEvaluation clearDatasetGroupings() {
        this.datasetGroupings.clear();
        return this;
    }

    public MultipleClassifierEvaluation setUseDefaultEvaluationStatistics() {
        this.statistics = ClassifierResultsAnalysis.getDefaultStatistics();
        return this;
    }

    public MultipleClassifierEvaluation setUseAccuracyOnly() {
        this.statistics = ClassifierResultsAnalysis.getAccuracyStatisticOnly();
        return this;
    }

    public MultipleClassifierEvaluation setUseAllStatistics() {
        this.statistics = ClassifierResultsAnalysis.getAllStatistics();
        return this;
    }

    public MultipleClassifierEvaluation addEvaluationStatistic(String statName, Function<ClassifierResults, Double> classifierResultsManipulatorFunction) {
        this.statistics.add(new Pair<String, Function<ClassifierResults, Double>>(statName, classifierResultsManipulatorFunction));
        return this;
    }

    public MultipleClassifierEvaluation removeEvaluationStatistic(String statName) {
        for (Pair<String, Function<ClassifierResults, Double>> statistic : this.statistics) {
            if (!((String)statistic.var1).equalsIgnoreCase(statName)) continue;
            this.statistics.remove(statistic);
        }
        return this;
    }

    public MultipleClassifierEvaluation clearEvaluationStatistics(String statName) {
        this.statistics.clear();
        return this;
    }

    public MultipleClassifierEvaluation addClassifier(String classifierName, ClassifierResults[][] trainDatasetFoldResults, ClassifierResults[][] testDatasetFoldResults) throws Exception {
        if (this.datasets.size() == 0) {
            throw new Exception("No datasets set for evaluation");
        }
        for (int d = 0; d < testDatasetFoldResults.length; ++d) {
            for (int f = 0; f < testDatasetFoldResults[d].length; ++f) {
                if (!this.testResultsOnly && trainDatasetFoldResults != null) {
                    trainDatasetFoldResults[d][f].findAllStatsOnce();
                    if (this.cleanResults) {
                        trainDatasetFoldResults[d][f].cleanPredictionInfo();
                    }
                }
                testDatasetFoldResults[d][f].findAllStatsOnce();
                if (!this.cleanResults) continue;
                testDatasetFoldResults[d][f].cleanPredictionInfo();
            }
        }
        this.classifiersResults.put(classifierName, new ClassifierResults[][][]{trainDatasetFoldResults, testDatasetFoldResults});
        return this;
    }

    public MultipleClassifierEvaluation addClassifiers(String[] classifierNames, ClassifierResults[][][] trainClassifierDatasetFoldResults, ClassifierResults[][][] testClassifierDatasetFoldResults) throws Exception {
        for (int i = 0; i < classifierNames.length; ++i) {
            this.addClassifier(classifierNames[i], trainClassifierDatasetFoldResults[i], trainClassifierDatasetFoldResults[i]);
        }
        return this;
    }

    public MultipleClassifierEvaluation readInClassifier(String classifierName, String baseReadPath) throws Exception {
        return this.readInClassifier(classifierName, classifierName, baseReadPath);
    }

    public MultipleClassifierEvaluation readInClassifier(String classifierNameInStorage, String classifierNameInOutput, String baseReadPath) throws Exception {
        if (this.datasets.size() == 0) {
            throw new Exception("No datasets set for evaluation");
        }
        if (baseReadPath.charAt(baseReadPath.length() - 1) != '/') {
            baseReadPath = baseReadPath + "/";
        }
        this.printlnDebug(classifierNameInStorage + "(" + classifierNameInOutput + ") reading");
        int totalFnfs = 0;
        ErrorReport er = new ErrorReport("FileNotFoundExceptions thrown (### total):\n");
        ClassifierResults[][][] results = new ClassifierResults[2][this.datasets.size()][this.numFolds];
        if (this.testResultsOnly) {
            results[0] = null;
        }
        boolean onlyAccsWanted = true;
        for (Pair<String, Function<ClassifierResults, Double>> statistic : this.statistics) {
            if (((String)statistic.var1).equals("ACC")) continue;
            onlyAccsWanted = false;
            break;
        }
        for (int d = 0; d < this.datasets.size(); ++d) {
            for (int f = 0; f < this.numFolds; ++f) {
                if (!this.testResultsOnly) {
                    String trainFile = baseReadPath + classifierNameInStorage + "/Predictions/" + this.datasets.get(d) + "/trainFold" + f + ".csv";
                    try {
                        results[0][d][f] = new ClassifierResults(trainFile);
                        if (!onlyAccsWanted) {
                            results[0][d][f].findAllStatsOnce();
                        }
                        if (this.cleanResults) {
                            results[0][d][f].cleanPredictionInfo();
                        }
                    }
                    catch (FileNotFoundException ex) {
                        er.log(trainFile + "\n");
                        ++totalFnfs;
                    }
                }
                String testFile = baseReadPath + classifierNameInStorage + "/Predictions/" + this.datasets.get(d) + "/testFold" + f + ".csv";
                try {
                    results[1][d][f] = new ClassifierResults(testFile);
                    if (!onlyAccsWanted) {
                        results[1][d][f].findAllStatsOnce();
                    }
                    if (!this.cleanResults) continue;
                    results[1][d][f].cleanPredictionInfo();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    er.log(testFile + "\n");
                    ++totalFnfs;
                }
            }
        }
        er.getLog().replace("###", totalFnfs + "");
        er.throwIfErrors();
        this.printlnDebug(classifierNameInStorage + "(" + classifierNameInOutput + ") successfully read in");
        this.classifiersResults.put(classifierNameInOutput, results);
        return this;
    }

    public MultipleClassifierEvaluation readInClassifiers(String[] classifierNames, String baseReadPath) throws Exception {
        return this.readInClassifiers(classifierNames, classifierNames, baseReadPath);
    }

    public MultipleClassifierEvaluation readInClassifiers(String[] classifierNamesInStorage, String[] classifierNamesInOutput, String baseReadPath) throws Exception {
        if (classifierNamesInOutput.length != classifierNamesInStorage.length) {
            throw new Exception("Sizes of the classifier names to read in and use in output differ: classifierNamesInStorage.length=" + classifierNamesInStorage.length + ", classifierNamesInOutput.length=" + classifierNamesInOutput.length);
        }
        ErrorReport er = new ErrorReport("Results files not found:\n");
        for (int i = 0; i < classifierNamesInStorage.length; ++i) {
            try {
                this.readInClassifier(classifierNamesInStorage[i], classifierNamesInOutput[i], baseReadPath);
                continue;
            }
            catch (Exception e) {
                er.log("Classifier Errors: " + classifierNamesInStorage[i] + "\n" + e);
            }
        }
        er.throwIfErrors();
        return this;
    }

    public MultipleClassifierEvaluation removeClassifier(String classifierName) {
        this.classifiersResults.remove(classifierName);
        return this;
    }

    public MultipleClassifierEvaluation clearClassifiers() {
        this.classifiersResults.clear();
        return this;
    }

    public void runComparison() {
        ArrayList<ClassifierResultsAnalysis.ClassifierEvaluation> results = new ArrayList<ClassifierResultsAnalysis.ClassifierEvaluation>(this.classifiersResults.size());
        for (Map.Entry<String, ClassifierResults[][][]> classifier : this.classifiersResults.entrySet()) {
            results.add(new ClassifierResultsAnalysis.ClassifierEvaluation(classifier.getKey(), classifier.getValue()[1], classifier.getValue()[0], null));
        }
        ClassifierResultsAnalysis.buildMatlabDiagrams = this.buildMatlabDiagrams;
        ClassifierResultsAnalysis.testResultsOnly = this.testResultsOnly;
        if (this.performPostHocDsetResultsClustering) {
            this.datasetGroupings.put("PostHocXmeansClustering", null);
        }
        this.printlnDebug("Writing started");
        ClassifierResultsAnalysis.writeAllEvaluationFiles(this.writePath, this.experimentName, this.statistics, results, this.datasets.toArray(new String[0]), this.datasetGroupings);
        this.printlnDebug("Writing finished");
        if (this.buildMatlabDiagrams) {
            MatlabController.getInstance().discconnectMatlab();
        }
    }

    public static void main(String[] args) throws Exception {
        MultipleClassifierEvaluation.workingExampleCodeHopefullyRunnableEntirelyOnBeast();
    }

    public static void workingExampleCodeHopefullyRunnableEntirelyOnBeast() throws FileNotFoundException, Exception {
        String folderToWriteAnalysisTo = "Z:/Results/FinalisedUCIContinuousAnalysis/WORKINGEXAMPLE/";
        String nameOfAnalysisWhichWillBecomeFolderName = "Example1";
        int numberOfFoldsAKAResamplesOfEachDataset = 10;
        MultipleClassifierEvaluation mce = new MultipleClassifierEvaluation(folderToWriteAnalysisTo, nameOfAnalysisWhichWillBecomeFolderName, numberOfFoldsAKAResamplesOfEachDataset);
        String aFileWithListOfDsetsToUse = "Z:/Results/FinalisedUCIContinuousAnalysis/WORKINGEXAMPLE/dsets.txt";
        mce.setDatasets(aFileWithListOfDsetsToUse);
        String aDirectoryContainingFilesThatDefineDatasetGroupings = "Z:/Results/FinalisedUCIContinuousAnalysis/WORKINGEXAMPLE/dsetGroupings/evenAndOddDsets/";
        String andAnother = "Z:/Results/FinalisedUCIContinuousAnalysis/WORKINGEXAMPLE/dsetGroupings/topAndBotHalves/";
        mce.addDatasetGroupingFromDirectory(aDirectoryContainingFilesThatDefineDatasetGroupings);
        mce.addDatasetGroupingFromDirectory(andAnother);
        mce.setPerformPostHocDsetResultsClustering(true);
        String[] classifiers = new String[]{"1NN", "C4.5", "NB"};
        String directoryWithResultsClassifierByClassifier = "Z:/Results/FinalisedUCIContinuous/";
        mce.readInClassifiers(classifiers, directoryWithResultsClassifierByClassifier);
        mce.runComparison();
    }
}

