/*
 * Decompiled with CFR 0.152.
 */
package development;

import fileIO.OutFile;
import statistics.simulators.Model;
import statistics.simulators.SimulateMatrixProfileData;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.FlatCote;
import timeseriesweka.classifiers.HiveCote;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import timeseriesweka.filters.MatrixProfile;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import vector_classifiers.CAWPE;
import vector_classifiers.TunedRandomForest;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.RotationForest;
import weka.core.Instances;
import weka.filters.NormalizeCase;

public class MatrixProfileExperiments {
    static boolean local = false;
    static int[] casesPerClass = new int[]{50, 50};
    static int seriesLength = 500;
    static double trainProp = 0.5;
    static boolean normalize = true;
    static String[] allClassifiers = new String[]{"ED", "RotF", "DTW", "EE", "HESCA", "TSF", "ST", "BOSS", "RISE", "FLATCOTE", "HIVECOTE"};

    public static Classifier setClassifier(String str) throws RuntimeException {
        AbstractClassifier c;
        switch (str) {
            case "ED": 
            case "MP_ED": {
                c = new kNN(1);
                break;
            }
            case "HESCA": {
                c = new CAWPE();
                break;
            }
            case "RandF": 
            case "MP_RotF": {
                c = new TunedRandomForest();
                break;
            }
            case "RotF": {
                c = new RotationForest();
                break;
            }
            case "DTW": 
            case "MP_DTW": {
                c = new DTW1NN();
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "EE": {
                c = new ElasticEnsemble();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            case "FastShapelets": {
                c = new FastShapelets();
                break;
            }
            case "ST": {
                c = new ST_HESCA();
                if (local) {
                    ((ST_HESCA)c).setOneMinuteLimit();
                    break;
                }
                ((ST_HESCA)c).setOneHourLimit();
                break;
            }
            case "BOP": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": {
                c = new BOSS();
                break;
            }
            case "COTE": 
            case "FLATCOTE": {
                c = new FlatCote();
                break;
            }
            case "HIVECOTE": {
                c = new HiveCote();
                break;
            }
            case "RISE": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                ((RISE)c).setNosBaseClassifiers(500);
                break;
            }
            case "RISE_HESCA": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                CAWPE base = new CAWPE();
                ((RISE)c).setBaseClassifier(base);
                ((RISE)c).setNosBaseClassifiers(20);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN CLASSIFIER " + str);
            }
        }
        return c;
    }

    public static void main(String[] args) throws Exception {
        int j;
        seriesLength = 200;
        trainProp = 0.1;
        casesPerClass = new int[]{50, 50};
        Model.setDefaultSigma(1.0);
        int folds = 100;
        boolean numMPClassifiers = true;
        String[] algos = new String[]{"MP_ED", "ED", "RotF", "DTW", "ST", "TSF", "BOSS", "RISE", "COTE"};
        double[] means = new double[algos.length];
        OutFile mpExample = new OutFile("C:\\temp\\mpResults.csv");
        OutFile mpW = new OutFile("C:\\temp\\mpWindows.csv");
        for (j = 0; j < algos.length; ++j) {
            mpExample.writeString("," + algos[j]);
        }
        mpExample.writeString("\n");
        for (int i = 0; i < folds; ++i) {
            mpExample.writeString(i + 1 + "");
            Model.setGlobalRandomSeed(i);
            Instances d = SimulateMatrixProfileData.generateMatrixProfileData(seriesLength, casesPerClass);
            Instances[] split = InstanceTools.resampleInstances(d, i, trainProp);
            kNN knn = new kNN();
            knn.setKNN(1);
            MatrixProfile mp = new MatrixProfile(29);
            Instances[] mpSplit = new Instances[2];
            Instances[] normSplit = new Instances[2];
            mpSplit[0] = mp.process(split[0]);
            mpSplit[1] = mp.process(split[1]);
            NormalizeCase nc = new NormalizeCase();
            normSplit[0] = nc.process(split[0]);
            normSplit[1] = nc.process(split[1]);
            int j2 = 0;
            while (j2 < algos.length) {
                Classifier c = MatrixProfileExperiments.setClassifier(algos[j2]);
                double acc = algos[j2].contains("MP_") ? ClassifierTools.singleTrainTestSplitAccuracy(c, mpSplit[0], mpSplit[1]) : ClassifierTools.singleTrainTestSplitAccuracy(c, normSplit[0], normSplit[1]);
                System.out.println("Classifier " + algos[j2] + " acc =" + acc);
                int n = j2++;
                means[n] = means[n] + acc;
                mpExample.writeString("," + (1.0 - acc));
            }
            mpExample.writeString("\n");
        }
        for (j = 0; j < algos.length; ++j) {
            System.out.println(algos[j] + " mean acc = " + means[j] / (double)folds);
        }
    }
}

