/*
 * Decompiled with CFR 0.152.
 */
package applications;

import applications.ApplicationTemplate;
import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import papers.bagnall17defaultparas.UCIExperiments;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.CAWPE;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class RedaProblem {
    public static String problemName;
    static boolean sampleByAttribute;
    static double proportionInTrain;
    static int folds;
    public static final String[] sampleID;
    static String[] classifiers;

    public static void singleExperiment() {
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\Data\\Reda Fungus Paths\\funguspaths_forfoundbubbles_improved");
        CAWPE c = new CAWPE();
        double[][] d = ClassifierTools.crossValidationWithStats(c, train, 10);
        System.out.println("Accuracy of " + c.getClass().getName() + " = " + d[0][0]);
        OutFile of = new OutFile("C:\\Users\\ajb\\Dropbox\\Results\\Reda\\FungusResults.csv");
        for (int i = 0; i < d[0].length; ++i) {
            of.writeLine(d[0][i] + "," + d[1][i]);
        }
    }

    public static void setProblemName(String s) {
        problemName = s;
    }

    public static void setSampleByAttribute(boolean b) {
        sampleByAttribute = b;
    }

    static Instances[] sample(int fold) {
        Instances all = ClassifierTools.loadData(DataSets.problemPath + "/" + problemName + "/" + problemName);
        Instances[] split = new Instances[2];
        if (sampleByAttribute) {
            split[0] = new Instances(all, 0);
            split[1] = new Instances(all, 0);
            for (Instance ins : all) {
                if (ins.stringValue(0).equals(sampleID[fold])) {
                    split[1].add(ins);
                    continue;
                }
                split[0].add(ins);
            }
            split[0].deleteAttributeAt(0);
            split[1].deleteAttributeAt(0);
        } else {
            split = InstanceTools.resampleInstances(all, fold, proportionInTrain);
        }
        return split;
    }

    public static void collateResults() {
        String resultsPath = DataSets.resultsPath + problemName + "Results/";
        OutFile out = new OutFile(resultsPath + "collatedResults.csv");
        for (String c : classifiers) {
            out.writeString("," + c);
        }
        out.writeString("\n");
        for (int i = 0; i < folds; ++i) {
            out.writeString("Fold" + (i + 1));
            for (String c : classifiers) {
                String p = resultsPath + c + "/Predictions/" + problemName + "/testFold" + i + ".csv";
                File f = new File(p);
                if (f.exists() && f.length() > 0L) {
                    InFile inf = new InFile(p);
                    inf.readLine();
                    inf.readLine();
                    out.writeString("," + inf.readDouble());
                    continue;
                }
                out.writeString(",");
            }
            out.writeString("\n");
        }
    }

    public static void singleClassifierAndFold(String[] args) {
        String classifier = args[0];
        int fold = Integer.parseInt(args[1]) - 1;
        Classifier c = UCIExperiments.setClassifier(classifier);
        Instances[] split = RedaProblem.sample(fold);
        String predictions = DataSets.resultsPath + classifier + "/Predictions";
        File f = new File(predictions = predictions + "/" + problemName);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            double acc = ApplicationTemplate.singleClassifierAndFold(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + problemName + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFold(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
        }
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            OutFile p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void createScripts(boolean grace, int mem) {
        int folds = 10;
        String path = DataSets.dropboxPath + "\\Cluster Scripts\\";
        File f = new File(path = path + problemName + "Scripts\\");
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        OutFile of2 = grace ? new OutFile(path + problemName + "Grace.txt") : new OutFile(path + problemName + ".txt");
        for (String s : classifiers) {
            OutFile of = grace ? new OutFile(path + s + "Grace.bsub") : new OutFile(path + s + ".bsub");
            of.writeLine("#!/bin/csh");
            if (grace) {
                of.writeLine("#BSUB -q short");
            } else {
                of.writeLine("#BSUB -q long-eth");
            }
            if (sampleByAttribute) {
                of.writeLine("#BSUB -J " + problemName + s + "[1-" + sampleID.length + "]");
            } else {
                of.writeLine("#BSUB -J " + problemName + s + "[1-" + folds + "]");
            }
            of.writeLine("#BSUB -oo output/" + problemName + s + ".out");
            of.writeLine("#BSUB -eo error/" + problemName + s + ".err");
            if (grace) {
                of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                of.writeLine("#BSUB -M " + mem);
                of.writeLine(" module add java/jdk/1.8.0_31");
            } else {
                of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                of.writeLine("#BSUB -M " + mem);
                of.writeLine("module add java/jdk1.8.0_51");
            }
            of.writeLine("java -jar " + problemName + ".jar " + s + "  $LSB_JOBINDEX");
            if (grace) {
                of2.writeLine("bsub < Scripts/" + problemName + "Scripts/" + s + "Grace.bsub");
                continue;
            }
            of2.writeLine("bsub < Scripts/" + problemName + "Scripts/" + s + ".bsub");
        }
    }

    public static void main(String[] args) {
        RedaProblem.setProblemName("RedaProblem");
        RedaProblem.setSampleByAttribute(false);
        proportionInTrain = 0.1;
        DataSets.dropboxPath = "C:/Users/ajb/Dropbox/";
        DataSets.clusterPath = "/gpfs/home/ajb/";
        RedaProblem.collateResults();
        System.exit(0);
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "Data/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/" + problemName + "Results/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdir();
            }
            RedaProblem.singleClassifierAndFold(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "Data/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/" + problemName + "Results/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdir();
            }
            String[] paras = new String[]{"NB", "6"};
            RedaProblem.singleClassifierAndFold(paras);
        }
    }

    static {
        sampleByAttribute = false;
        proportionInTrain = 0.3;
        folds = 10;
        sampleID = new String[]{"aberfeldy", "aberlour", "amrut", "ancnoc", "armorik", "arran10", "arran14", "asyla", "benromach", "bladnoch", "blairathol", "exhibition", "glencadam", "glendeveron", "glenfarclas", "glengoyne", "glenlivet15", "glenmorangie", "glenmoray", "glenscotia", "oakcross", "organic", "peatmonster", "scapa", "smokehead", "speyburn", "spicetree", "talisker"};
        classifiers = new String[]{"IBk", "C45", "OptimisedSVM", "RandF", "RotF", "HESCA", "SVML", "SVMQ", "MLP"};
    }
}

