/*
 * Decompiled with CFR 0.152.
 */
package applications;

import development.DataSets;
import development.MatrixProfileExperiments;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class CroppedEthanolLevel {
    public static String problemName = "CroppedEthanolLevel";
    static boolean sampleByAttribute = false;
    static double proportionInTrain = 0.3;
    public static final String[] sampleID = new String[]{"aberfeldy", "aberlour", "amrut", "ancnoc", "armorik", "arran10", "arran14", "asyla", "benromach", "bladnoch", "blairathol", "exhibition", "glencadam", "glendeveron", "glenfarclas", "glengoyne", "glenlivet15", "glenmorangie", "glenmoray", "glenscotia", "oakcross", "organic", "peatmonster", "scapa", "smokehead", "speyburn", "spicetree", "talisker"};
    static String[] classifiers = new String[]{"ED", "RotF", "DTW", "EE", "HESCA", "TSF", "ST", "BOSS", "RISE", "FLATCOTE", "HIVECOTE"};
    static int[] classifierMems = new int[]{2000, 2000, 2000, 3000, 4000, 4000, 4000, 4000, 4000, 4000, 4000};
    static String[] classifierQueues = new String[]{"short", "short", "short", "long", "short", "short", "short", "short", "short", "long", "long"};

    public static void setProblemName(String s) {
        problemName = s;
    }

    public static void setSampleByAttribute(boolean b) {
        sampleByAttribute = b;
    }

    static Instances[] sample(int fold) {
        Instances all = ClassifierTools.loadData(DataSets.problemPath + "/" + problemName + "/" + problemName);
        Instances[] split = new Instances[2];
        if (sampleByAttribute) {
            split[0] = new Instances(all, 0);
            split[1] = new Instances(all, 0);
            for (Instance ins : all) {
                if (ins.stringValue(0).equals(sampleID[fold])) {
                    split[1].add(ins);
                    continue;
                }
                split[0].add(ins);
            }
            split[0].deleteAttributeAt(0);
            split[1].deleteAttributeAt(0);
        } else {
            split = InstanceTools.resampleInstances(all, fold, proportionInTrain);
        }
        return split;
    }

    public static void collateResults() {
        String resultsPath = DataSets.resultsPath + problemName + "Results/";
        OutFile out = new OutFile(resultsPath + problemName + "Collated.csv");
        for (String c : classifiers) {
            out.writeString("," + c);
        }
        out.writeString("\n");
        for (int i = 0; i < sampleID.length; ++i) {
            out.writeString(sampleID[i]);
            for (String c : classifiers) {
                String p = resultsPath + c + "/Predictions/" + problemName + "/testFold" + i + ".csv";
                File f = new File(p);
                if (f.exists() && f.length() > 0L) {
                    InFile inf = new InFile(p);
                    inf.readLine();
                    inf.readLine();
                    out.writeString("," + inf.readDouble());
                    continue;
                }
                out.writeString(",");
            }
            out.writeString("\n");
        }
    }

    public static void singleClassifierAndFold(String[] args) {
        String classifier = args[0];
        int fold = Integer.parseInt(args[1]) - 1;
        Classifier c = MatrixProfileExperiments.setClassifier(classifier);
        Instances[] split = CroppedEthanolLevel.sample(fold);
        String predictions = DataSets.resultsPath + classifier + "/Predictions";
        File f = new File(predictions = predictions + "/" + problemName);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            double acc = CroppedEthanolLevel.singleClassifierAndFold(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + problemName + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFold(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
        }
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            OutFile p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void createScripts(boolean grace) {
        int folds = 100;
        String path = DataSets.dropboxPath + "\\Cluster Scripts\\";
        File f = new File(path = path + problemName + "Scripts\\");
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        OutFile of2 = grace ? new OutFile(path + problemName + "Grace.txt") : new OutFile(path + problemName + ".txt");
        String outfileTag = "_%I";
        for (int i = 0; i < classifiers.length; ++i) {
            String s = classifiers[i];
            int mem = classifierMems[i];
            OutFile of = grace ? new OutFile(path + s + "Grace.bsub") : new OutFile(path + s + ".bsub");
            of.writeLine("#!/bin/csh");
            if (grace) {
                of.writeLine("#BSUB -q " + classifierQueues[i]);
            } else {
                of.writeLine("#BSUB -q " + classifierQueues[i] + "-eth");
            }
            if (sampleByAttribute) {
                of.writeLine("#BSUB -J " + problemName + s + "[1-" + sampleID.length + "]");
            } else {
                of.writeLine("#BSUB -J " + problemName + s + "[1-" + folds + "]");
            }
            of.writeLine("#BSUB -oo " + problemName + "/output/" + problemName + s + outfileTag + ".out");
            of.writeLine("#BSUB -eo " + problemName + "/error/" + problemName + s + outfileTag + ".err");
            if (grace) {
                of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                of.writeLine("#BSUB -M " + mem);
                of.writeLine(" module add java/jdk/1.8.0_31");
            } else {
                of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                of.writeLine("#BSUB -M " + mem);
                of.writeLine("module add java/jdk1.8.0_51");
            }
            of.writeLine("java -Xmx" + mem + "m -jar " + problemName + "/" + problemName + ".jar " + s + "  $LSB_JOBINDEX " + problemName);
            if (grace) {
                of2.writeLine("bsub < " + problemName + "/Scripts/" + s + "Grace.bsub");
                continue;
            }
            of2.writeLine("bsub < " + problemName + "/Scripts/" + s + ".bsub");
        }
    }

    public static void main(String[] args) {
        System.out.println("CroppedEthanolLevel Run");
        CroppedEthanolLevel.setProblemName("CroppedEthanol4Class_AllBottles");
        CroppedEthanolLevel.setSampleByAttribute(true);
        DataSets.dropboxPath = "C:/JamesLPHD/AlcoholExps/";
        DataSets.clusterPath = "/gpfs/home/xmw13bzu/";
        DataSets.resultsPath = DataSets.dropboxPath + "Results/";
        if (args.length > 0) {
            CroppedEthanolLevel.setProblemName(args[2]);
            DataSets.problemPath = DataSets.clusterPath + "TSC Problems/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/" + problemName + "Results/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdir();
            }
            CroppedEthanolLevel.singleClassifierAndFold(args);
        } else {
            DataSets.problemPath = "C:/TSC Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/" + problemName + "Results/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdir();
            }
            String[] paras = new String[]{"ED", "6"};
            CroppedEthanolLevel.singleClassifierAndFold(paras);
        }
    }
}

