/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends Serializer<Map> {
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;
    private Class keyGenericType;
    private Class valueGenericType;

    public void setKeysCanBeNull(boolean keysCanBeNull) {
        this.keysCanBeNull = keysCanBeNull;
    }

    public void setKeyClass(Class keyClass, Serializer keySerializer) {
        this.keyClass = keyClass;
        this.keySerializer = keySerializer;
    }

    public void setValueClass(Class valueClass, Serializer valueSerializer) {
        this.valueClass = valueClass;
        this.valueSerializer = valueSerializer;
    }

    public void setValuesCanBeNull(boolean valuesCanBeNull) {
        this.valuesCanBeNull = valuesCanBeNull;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        if (generics[0] != null && kryo.isFinal(generics[0])) {
            this.keyGenericType = generics[0];
        }
        if (generics[1] != null && kryo.isFinal(generics[1])) {
            this.valueGenericType = generics[1];
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Map map2) {
        int length = map2.size();
        output.writeInt(length, true);
        Serializer keySerializer = this.keySerializer;
        if (this.keyGenericType != null) {
            if (keySerializer == null) {
                keySerializer = kryo.getSerializer(this.keyGenericType);
            }
            this.keyGenericType = null;
        }
        Serializer valueSerializer = this.valueSerializer;
        if (this.valueGenericType != null) {
            if (valueSerializer == null) {
                valueSerializer = kryo.getSerializer(this.valueGenericType);
            }
            this.valueGenericType = null;
        }
        for (Map.Entry entry2 : map2.entrySet()) {
            if (keySerializer != null) {
                if (this.keysCanBeNull) {
                    kryo.writeObjectOrNull(output, entry2.getKey(), keySerializer);
                } else {
                    kryo.writeObject(output, entry2.getKey(), keySerializer);
                }
            } else {
                kryo.writeClassAndObject(output, entry2.getKey());
            }
            if (valueSerializer != null) {
                if (this.valuesCanBeNull) {
                    kryo.writeObjectOrNull(output, entry2.getValue(), valueSerializer);
                    continue;
                }
                kryo.writeObject(output, entry2.getValue(), valueSerializer);
                continue;
            }
            kryo.writeClassAndObject(output, entry2.getValue());
        }
    }

    protected Map create(Kryo kryo, Input input2, Class<Map> type) {
        return kryo.newInstance(type);
    }

    @Override
    public Map read(Kryo kryo, Input input2, Class<Map> type) {
        Map map2 = this.create(kryo, input2, type);
        int length = input2.readInt(true);
        Class keyClass = this.keyClass;
        Class valueClass = this.valueClass;
        Serializer keySerializer = this.keySerializer;
        if (this.keyGenericType != null) {
            keyClass = this.keyGenericType;
            if (keySerializer == null) {
                keySerializer = kryo.getSerializer(keyClass);
            }
            this.keyGenericType = null;
        }
        Serializer valueSerializer = this.valueSerializer;
        if (this.valueGenericType != null) {
            valueClass = this.valueGenericType;
            if (valueSerializer == null) {
                valueSerializer = kryo.getSerializer(valueClass);
            }
            this.valueGenericType = null;
        }
        kryo.reference(map2);
        for (int i = 0; i < length; ++i) {
            Object key = keySerializer != null ? (this.keysCanBeNull ? kryo.readObjectOrNull(input2, keyClass, keySerializer) : kryo.readObject(input2, keyClass, keySerializer)) : kryo.readClassAndObject(input2);
            Object value2 = valueSerializer != null ? (this.valuesCanBeNull ? kryo.readObjectOrNull(input2, valueClass, valueSerializer) : kryo.readObject(input2, valueClass, valueSerializer)) : kryo.readClassAndObject(input2);
            map2.put(key, value2);
        }
        return map2;
    }

    protected Map createCopy(Kryo kryo, Map original) {
        return (Map)kryo.newInstance(original.getClass());
    }

    @Override
    public Map copy(Kryo kryo, Map original) {
        Map copy2 = this.createCopy(kryo, original);
        for (Map.Entry entry2 : original.entrySet()) {
            copy2.put(kryo.copy(entry2.getKey()), kryo.copy(entry2.getValue()));
        }
        return copy2;
    }
}

