/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import java.io.OutputStream;

public class Output
extends OutputStream {
    private int maxCapacity;
    private int capacity;
    private int position;
    private int total;
    private byte[] buffer;
    private OutputStream outputStream;

    public Output() {
    }

    public Output(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public Output(int bufferSize, int maxBufferSize) {
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Output(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public Output(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.setBuffer(buffer, maxBufferSize);
    }

    public Output(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public Output(OutputStream outputStream, int bufferSize) {
        this(bufferSize, bufferSize);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.position = 0;
        this.total = 0;
    }

    public void setBuffer(byte[] buffer) {
        this.setBuffer(buffer, buffer.length);
    }

    public void setBuffer(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.buffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.capacity = buffer.length;
        this.position = 0;
        this.total = 0;
        this.outputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
        return newBuffer;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position2) {
        this.position = position2;
    }

    public int total() {
        return this.total + this.position;
    }

    public void clear() {
        this.position = 0;
        this.total = 0;
    }

    private boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        this.flush();
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] newBuffer = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        return true;
    }

    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        this.total += this.position;
        this.position = 0;
    }

    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(int value2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value2;
    }

    public void write(byte[] bytes2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes2, 0, bytes2.length);
    }

    public void write(byte[] bytes2, int offset, int length) throws KryoException {
        this.writeBytes(bytes2, offset, length);
    }

    public void writeByte(byte value2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = value2;
    }

    public void writeByte(int value2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value2;
    }

    public void writeBytes(byte[] bytes2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes2, 0, bytes2.length);
    }

    public void writeBytes(byte[] bytes2, int offset, int count2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count2);
        while (true) {
            System.arraycopy(bytes2, offset, this.buffer, this.position, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count2);
            this.require(copyCount);
        }
    }

    public void writeInt(int value2) throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value2 >> 24);
        buffer[this.position++] = (byte)(value2 >> 16);
        buffer[this.position++] = (byte)(value2 >> 8);
        buffer[this.position++] = (byte)value2;
    }

    public int writeInt(int value2, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80);
            this.buffer[this.position++] = (byte)(value2 >>> 21);
            return 4;
        }
        this.require(5);
        this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
        this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80);
        this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80);
        this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80);
        this.buffer[this.position++] = (byte)(value2 >>> 28);
        return 5;
    }

    public void writeString(String value2) throws KryoException {
        if (value2 == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value2.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean ascii = false;
        if (charCount > 1 && charCount < 64) {
            ascii = true;
            for (int i = 0; i < charCount; ++i) {
                char c = value2.charAt(i);
                if (c <= '\u007f') continue;
                ascii = false;
                break;
            }
        }
        if (ascii) {
            if (this.capacity - this.position < charCount) {
                this.writeAscii_slow(value2, charCount);
            } else {
                value2.getBytes(0, charCount, this.buffer, this.position);
                this.position += charCount;
            }
            int n = this.position - 1;
            this.buffer[n] = (byte)(this.buffer[n] | 0x80);
        } else {
            int charIndex;
            this.writeUtf8Length(charCount + 1);
            if (this.capacity - this.position >= charCount) {
                char c;
                byte[] buffer = this.buffer;
                int position2 = this.position;
                for (charIndex = 0; charIndex < charCount && (c = value2.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                    buffer[position2++] = (byte)c;
                }
                this.position = position2;
            }
            if (charIndex < charCount) {
                this.writeString_slow(value2, charCount, charIndex);
            }
        }
    }

    public void writeString(CharSequence value2) throws KryoException {
        int charIndex;
        if (value2 == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value2.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        if (this.capacity - this.position >= charCount) {
            char c;
            byte[] buffer = this.buffer;
            int position2 = this.position;
            for (charIndex = 0; charIndex < charCount && (c = value2.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                buffer[position2++] = (byte)c;
            }
            this.position = position2;
        }
        if (charIndex < charCount) {
            this.writeString_slow(value2, charCount, charIndex);
        }
    }

    public void writeAscii(String value2) throws KryoException {
        if (value2 == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value2.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value2, charCount);
        } else {
            value2.getBytes(0, charCount, this.buffer, this.position);
            this.position += charCount;
        }
        int n = this.position - 1;
        this.buffer[n] = (byte)(this.buffer[n] | 0x80);
    }

    private void writeUtf8Length(int value2) {
        if (value2 >>> 6 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)(value2 | 0x80);
        } else if (value2 >>> 13 == 0) {
            this.require(2);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value2 | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 6);
        } else if (value2 >>> 20 == 0) {
            this.require(3);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value2 | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 13);
        } else if (value2 >>> 27 == 0) {
            this.require(4);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value2 | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 20);
        } else {
            this.require(5);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value2 | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 20 | 0x80);
            buffer[this.position++] = (byte)(value2 >>> 27);
        }
    }

    private void writeString_slow(CharSequence value2, int charCount, int charIndex) {
        while (charIndex < charCount) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            if ((c = value2.charAt(charIndex)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.require(1);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value2, int charCount) throws KryoException {
        byte[] buffer = this.buffer;
        int charIndex = 0;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            value2.getBytes(charIndex, charIndex + charsToWrite, buffer, this.position);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            buffer = this.buffer;
        }
    }

    public void writeFloat(float value2) throws KryoException {
        this.writeInt(Float.floatToIntBits(value2));
    }

    public int writeFloat(float value2, float precision, boolean optimizePositive) throws KryoException {
        return this.writeInt((int)(value2 * precision), optimizePositive);
    }

    public void writeShort(int value2) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(value2 >>> 8);
        this.buffer[this.position++] = (byte)value2;
    }

    public void writeLong(long value2) throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value2 >>> 56);
        buffer[this.position++] = (byte)(value2 >>> 48);
        buffer[this.position++] = (byte)(value2 >>> 40);
        buffer[this.position++] = (byte)(value2 >>> 32);
        buffer[this.position++] = (byte)(value2 >>> 24);
        buffer[this.position++] = (byte)(value2 >>> 16);
        buffer[this.position++] = (byte)(value2 >>> 8);
        buffer[this.position++] = (byte)value2;
    }

    public int writeLong(long value2, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            this.require(1);
            this.buffer[this.position++] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 21);
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            this.require(5);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 28);
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            this.require(6);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 35);
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            this.require(7);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 42);
            return 7;
        }
        if (value2 >>> 56 == 0L) {
            this.require(8);
            this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 42 | 0x80L);
            this.buffer[this.position++] = (byte)(value2 >>> 49);
            return 8;
        }
        this.require(9);
        this.buffer[this.position++] = (byte)(value2 & 0x7FL | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 7 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 14 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 21 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 28 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 35 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 42 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 49 | 0x80L);
        this.buffer[this.position++] = (byte)(value2 >>> 56);
        return 9;
    }

    public void writeBoolean(boolean value2) throws KryoException {
        this.require(1);
        this.buffer[this.position++] = (byte)(value2 ? 1 : 0);
    }

    public void writeChar(char value2) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(value2 >>> 8);
        this.buffer[this.position++] = (byte)value2;
    }

    public void writeDouble(double value2) throws KryoException {
        this.writeLong(Double.doubleToLongBits(value2));
    }

    public int writeDouble(double value2, double precision, boolean optimizePositive) throws KryoException {
        return this.writeLong((long)(value2 * precision), optimizePositive);
    }

    public static int intLength(int value2, boolean optimizePositive) {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            return 1;
        }
        if (value2 >>> 14 == 0) {
            return 2;
        }
        if (value2 >>> 21 == 0) {
            return 3;
        }
        if (value2 >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int longLength(long value2, boolean optimizePositive) {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            return 7;
        }
        if (value2 >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }
}

