/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.util.Unsafe;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractNodeQueue<T>
extends AtomicReference<Node<T>> {
    private volatile Node<T> _tailDoNotCallMeDirectly;
    private static final long tailOffset;

    protected AbstractNodeQueue() {
        Node node = new Node();
        this._tailDoNotCallMeDirectly = node;
        this.set(node);
    }

    protected final Node<T> peekNode() {
        Node node;
        Node node2;
        while ((node2 = (node = (Node)Unsafe.instance.getObjectVolatile(this, tailOffset)).next()) == null && this.get() != node) {
        }
        return node2;
    }

    public final T peek() {
        Node<T> node = this.peekNode();
        return node != null ? (T)node.value : null;
    }

    public final void add(T t) {
        Node<T> node = new Node<T>(t);
        this.getAndSet(node).setNext(node);
    }

    public final void addNode(Node<T> node) {
        node.setNext(null);
        this.getAndSet(node).setNext(node);
    }

    public final boolean isEmpty() {
        return this.peek() == null;
    }

    public final int count() {
        int n = 0;
        for (Node<T> node = this.peekNode(); node != null; node = node.next()) {
            ++n;
        }
        return n;
    }

    public final T poll() {
        Node<T> node = this.peekNode();
        if (node == null) {
            return null;
        }
        Object t = node.value;
        node.value = null;
        Unsafe.instance.putOrderedObject(this, tailOffset, node);
        return t;
    }

    public final Node<T> pollNode() {
        Node node;
        Node node2;
        while ((node2 = (node = (Node)Unsafe.instance.getObjectVolatile(this, tailOffset)).next()) == null && this.get() != node) {
        }
        if (node2 == null) {
            return null;
        }
        node.value = node2.value;
        node2.value = null;
        Unsafe.instance.putOrderedObject(this, tailOffset, node2);
        return node;
    }

    static {
        try {
            tailOffset = Unsafe.instance.objectFieldOffset(AbstractNodeQueue.class.getDeclaredField("_tailDoNotCallMeDirectly"));
        }
        catch (Throwable throwable2) {
            throw new ExceptionInInitializerError(throwable2);
        }
    }

    public static class Node<T> {
        public T value;
        private volatile Node<T> _nextDoNotCallMeDirectly;
        private static final long nextOffset;

        public Node() {
            this(null);
        }

        public Node(T t) {
            this.value = t;
        }

        public final Node<T> next() {
            return (Node)Unsafe.instance.getObjectVolatile(this, nextOffset);
        }

        protected final void setNext(Node<T> node) {
            Unsafe.instance.putOrderedObject(this, nextOffset, node);
        }

        static {
            try {
                nextOffset = Unsafe.instance.objectFieldOffset(Node.class.getDeclaredField("_nextDoNotCallMeDirectly"));
            }
            catch (Throwable throwable2) {
                throw new ExceptionInInitializerError(throwable2);
            }
        }
    }
}

