/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorCell$;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ChildActorPath;
import akka.actor.ChildNameReserved$;
import akka.actor.ChildRestartStats;
import akka.actor.ChildRestartStats$;
import akka.actor.ChildStats;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.LocalScope$;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Nobody$;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.Scope;
import akka.actor.dungeon.AbstractActorCell;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.Helpers$;
import akka.util.Unsafe;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public abstract class Children$class {
    public static ChildrenContainer childrenRefs(ActorCell $this) {
        return (ChildrenContainer)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.childrenOffset);
    }

    public static final Iterable children(ActorCell $this) {
        return $this.childrenRefs().children();
    }

    public static final java.lang.Iterable getChildren(ActorCell $this) {
        return JavaConverters$.MODULE$.asJavaIterableConverter($this.children()).asJava();
    }

    public static final Option child(ActorCell $this, String name) {
        return Option$.MODULE$.apply($this.getChild(name));
    }

    public static final ActorRef getChild(ActorCell $this, String name) {
        ActorRef actorRef;
        Some some;
        ChildStats s2;
        Option<ChildStats> option = $this.childrenRefs().getByName(name);
        if (option instanceof Some && (s2 = (ChildStats)(some = (Some)option).x()) instanceof ChildRestartStats) {
            ChildRestartStats childRestartStats = (ChildRestartStats)s2;
            actorRef = childRestartStats.child();
        } else {
            actorRef = null;
        }
        return actorRef;
    }

    public static ActorRef actorOf(ActorCell $this, Props props2) {
        return Children$class.makeChild($this, $this, props2, $this.randomName(), false, false);
    }

    public static ActorRef actorOf(ActorCell $this, Props props2, String name) {
        return Children$class.makeChild($this, $this, props2, Children$class.checkName($this, name), false, false);
    }

    public static ActorRef attachChild(ActorCell $this, Props props2, boolean systemService) {
        return Children$class.makeChild($this, $this, props2, $this.randomName(), true, systemService);
    }

    public static ActorRef attachChild(ActorCell $this, Props props2, String name, boolean systemService) {
        return Children$class.makeChild($this, $this, props2, Children$class.checkName($this, name), true, systemService);
    }

    public static final String randomName(ActorCell $this) {
        return Helpers$.MODULE$.base64(Children$class.inc$1($this), Helpers$.MODULE$.base64$default$2());
    }

    public static final void stop(ActorCell $this, ActorRef actor) {
        Serializable serializable;
        if ($this.childrenRefs().getByRef(actor).isDefined()) {
            boolean bl;
            ActorRef actorRef = actor;
            if (actorRef instanceof RepointableRef) {
                ActorRef actorRef2 = actorRef;
                bl = ((RepointableRef)((Object)actorRef2)).isStarted();
            } else {
                bl = true;
            }
            serializable = bl ? BoxesRunTime.boxToBoolean(Children$class.shallDie$1($this, actor)) : BoxedUnit.UNIT;
        } else {
            serializable = BoxedUnit.UNIT;
        }
        ((InternalActorRef)actor).stop();
    }

    private static final boolean swapChildrenRefs(ActorCell $this, ChildrenContainer oldChildren, ChildrenContainer newChildren) {
        return Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.childrenOffset, oldChildren, newChildren);
    }

    public static final boolean reserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.reserve(name))) continue;
            return true;
        }
    }

    public static final boolean unreserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.unreserve(name))) continue;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final Option initChild(ActorCell $this, ActorRef ref2) {
        void var7_12;
        Option<ChildStats> option;
        block3: {
            ChildRestartStats crs;
            String name;
            ChildrenContainer cc;
            do {
                ChildStats childStats;
                cc = $this.childrenRefs();
                boolean bl = false;
                Some some = null;
                option = cc.getByName(ref2.path().name());
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    if (some.x() instanceof ChildRestartStats) {
                        Some some2 = some;
                        return var7_12;
                    }
                }
                if (!bl || !ChildNameReserved$.MODULE$.equals(childStats = (ChildStats)some.x())) break block3;
                crs = new ChildRestartStats(ref2, ChildRestartStats$.MODULE$.apply$default$2(), ChildRestartStats$.MODULE$.apply$default$3());
            } while (!Children$class.swapChildrenRefs($this, cc, cc.add(name = ref2.path().name(), crs)));
            Some<ChildRestartStats> some = new Some<ChildRestartStats>(crs);
            return var7_12;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        None$ none$ = None$.MODULE$;
        return var7_12;
    }

    public static final boolean setChildrenTerminationReason(ActorCell $this, ChildrenContainer.SuspendReason reason) {
        boolean bl;
        block1: {
            ChildrenContainer childrenContainer;
            while ((childrenContainer = $this.childrenRefs()) instanceof ChildrenContainer.TerminatingChildrenContainer) {
                Set<ActorRef> x$4;
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                ChildrenContainer.SuspendReason x$2 = reason;
                TreeMap<String, ChildStats> x$3 = terminatingChildrenContainer.copy$default$1();
                if (!Children$class.swapChildrenRefs($this, terminatingChildrenContainer, terminatingChildrenContainer.copy(x$3, x$4 = terminatingChildrenContainer.copy$default$2(), x$2))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final void setTerminated(ActorCell $this) {
        Unsafe.instance.putObjectVolatile($this, AbstractActorCell.childrenOffset, ChildrenContainer$TerminatedChildrenContainer$.MODULE$);
    }

    public static boolean isNormal(ActorCell $this) {
        return $this.childrenRefs().isNormal();
    }

    public static boolean isTerminating(ActorCell $this) {
        return $this.childrenRefs().isTerminating();
    }

    public static ChildrenContainer.SuspendReason waitingForChildrenOrNull(ActorCell $this) {
        ChildrenContainer.SuspendReason suspendReason;
        ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer;
        ChildrenContainer.SuspendReason w;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        ChildrenContainer.SuspendReason suspendReason2 = childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer && (w = (terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer).reason()) instanceof ChildrenContainer.WaitingForChildren ? (suspendReason = w) : null;
        return suspendReason2;
    }

    public static void suspendChildren(ActorCell $this, Set exceptFor) {
        $this.childrenRefs().stats().foreach(new scala.Serializable($this, exceptFor){
            public static final long serialVersionUID = 0L;
            private final Set exceptFor$1;

            public final void apply(ChildRestartStats x0$1) {
                ActorRef child;
                ChildRestartStats childRestartStats = x0$1;
                if (childRestartStats != null && !this.exceptFor$1.contains(child = childRestartStats.child())) {
                    ((InternalActorRef)child).suspend();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.exceptFor$1 = exceptFor$1;
            }
        });
    }

    public static Set suspendChildren$default$1(ActorCell $this) {
        return Predef$.MODULE$.Set().empty();
    }

    public static void resumeChildren(ActorCell $this, Throwable causedByFailure, ActorRef perp) {
        $this.childrenRefs().stats().foreach(new scala.Serializable($this, causedByFailure, perp){
            public static final long serialVersionUID = 0L;
            private final Throwable causedByFailure$1;
            private final ActorRef perp$1;

            public final void apply(ChildRestartStats x0$2) {
                ActorRef child;
                ChildRestartStats childRestartStats = x0$2;
                if (childRestartStats != null && (child = childRestartStats.child()) instanceof InternalActorRef) {
                    InternalActorRef internalActorRef = (InternalActorRef)child;
                    ActorRef actorRef = this.perp$1;
                    InternalActorRef internalActorRef2 = internalActorRef;
                    internalActorRef.resume(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef2) : internalActorRef2 != null) ? this.causedByFailure$1 : null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(childRestartStats);
            }
            {
                this.causedByFailure$1 = causedByFailure$1;
                this.perp$1 = perp$1;
            }
        });
    }

    public static Option getChildByName(ActorCell $this, String name) {
        return $this.childrenRefs().getByName(name);
    }

    public static Option getChildByRef(ActorCell $this, ActorRef ref2) {
        return $this.childrenRefs().getByRef(ref2);
    }

    public static Iterable getAllChildStats(ActorCell $this) {
        return $this.childrenRefs().stats();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static InternalActorRef getSingleChild(ActorCell $this, String name) {
        block6: {
            block5: {
                block4: {
                    if (name.indexOf(35) != -1) break block4;
                    var2_2 = $this.getChildByName(name);
                    if (var2_2 instanceof Some && (crs = (ChildStats)(var3_3 = (Some)var2_2).x()) instanceof ChildRestartStats) {
                        var5_5 = (ChildRestartStats)crs;
                        var6_6 /* !! */  = (InternalActorRef)var5_5.child();
                    } else {
                        var6_6 /* !! */  = Nobody$.MODULE$;
                    }
                    v0 = var6_6 /* !! */ ;
                    break block5;
                }
                var8_7 = ActorCell$.MODULE$.splitNameAndUid(name);
                if (var8_7 == null) break block6;
                childName = var8_7._1();
                uid = var8_7._2$mcI$sp();
                var7_11 = var11_10 = new Tuple2<String, Integer>(childName, BoxesRunTime.boxToInteger(uid));
                childName = var7_11._1();
                uid = var7_11._2$mcI$sp();
                var14_14 = $this.getChildByName(childName);
                if (!(var14_14 instanceof Some) || !((crs = (ChildStats)(var15_15 = (Some)var14_14).x()) instanceof ChildRestartStats)) ** GOTO lbl-1000
                var17_17 = (ChildRestartStats)crs;
                if (uid == 0 || uid == var17_17.uid()) {
                    var18_18 /* !! */  = (InternalActorRef)var17_17.child();
                } else lbl-1000:
                // 2 sources

                {
                    var18_18 /* !! */  = Nobody$.MODULE$;
                }
                v0 = var18_18 /* !! */ ;
            }
            return v0;
        }
        throw new MatchError(var8_7);
    }

    public static Option removeChildAndGetStateChange(ActorCell $this, ActorRef child) {
        None$ none$;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
            ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
            ChildrenContainer.SuspendReason reason = terminatingChildrenContainer.reason();
            ChildrenContainer childrenContainer2 = Children$class.removeChild$1($this, child);
            Option option = childrenContainer2 instanceof ChildrenContainer.TerminatingChildrenContainer ? None$.MODULE$ : new Some<ChildrenContainer.SuspendReason>(reason);
            none$ = option;
        } else {
            Children$class.removeChild$1($this, child);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static String checkName(ActorCell $this, String name) {
        String string2 = name;
        if (string2 == null) {
            throw new InvalidActorNameException("actor name must not be null");
        }
        if ("".equals(string2)) {
            throw new InvalidActorNameException("actor name must not be empty");
        }
        if (ActorPath$.MODULE$.isValidPathElement(name)) {
            String string3 = name;
            return string3;
        }
        throw new InvalidActorNameException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal actor name [", "]. Actor paths MUST: not start with `$`, include only ASCII letters and can only contain these special characters: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name, "-_.*$+:@&=,!~';"})));
    }

    /*
     * Loose catch block
     */
    private static ActorRef makeChild(ActorCell $this, ActorCell cell, Props props2, String name, boolean async, boolean systemService) {
        InternalActorRef actor;
        block10: {
            Serializable serializable;
            if (cell.system().settings().SerializeAllCreators() && !systemService) {
                Scope scope = props2.deploy().scope();
                LocalScope$ localScope$ = LocalScope$.MODULE$;
                if (scope == null ? localScope$ != null : !scope.equals(localScope$)) {
                    Serialization ser = (Serialization)SerializationExtension$.MODULE$.apply(cell.system());
                    serializable = BoxesRunTime.boxToBoolean(props2.args().forall((Function1<Object, Object>)((Object)new scala.Serializable($this, ser){
                        public static final long serialVersionUID = 0L;
                        private final Serialization ser$1;

                        public final boolean apply(Object arg) {
                            return arg instanceof NoSerializationVerificationNeeded || this.ser$1.deserialize(this.ser$1.serialize(arg).get(), arg.getClass()).get() != null;
                        }
                        {
                            this.ser$1 = ser$1;
                        }
                    })));
                }
            }
            serializable = BoxedUnit.UNIT;
            if (cell.childrenRefs().isTerminating()) {
                throw new IllegalStateException("cannot create children while terminating or terminated");
            }
            $this.reserveChild(name);
            try {
                ChildActorPath childPath = new ChildActorPath(cell.self().path(), name, ActorCell$.MODULE$.newUid());
                actor = cell.provider().actorOf(cell.systemImpl(), props2, cell.self(), childPath, systemService, None$.MODULE$, true, async);
                if ($this.mailbox() == null) break block10;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)throwable3;
                    $this.unreserveChild(name);
                    Thread.interrupted();
                    throw interruptedException;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                if (option.isEmpty()) {
                    throw throwable2;
                }
                Throwable e = option.get();
                $this.unreserveChild(name);
                throw e;
            }
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.mailbox().suspendCount()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable($this, actor){
                public static final long serialVersionUID = 0L;
                private final InternalActorRef actor$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.actor$1.suspend();
                }
                {
                    this.actor$1 = actor$1;
                }
            }));
        }
        $this.initChild(actor);
        actor.start();
        return actor;
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable5);
            if (option.isEmpty()) {
                throw throwable4;
            }
            Throwable e = option.get();
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pre-creation serialization check failed at [", "/", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{cell.self().path(), name})), e);
        }
    }

    private static final long inc$1(ActorCell $this) {
        while (true) {
            long current;
            if (!Unsafe.instance.compareAndSwapLong($this, AbstractActorCell.nextNameOffset, current = Unsafe.instance.getLongVolatile($this, AbstractActorCell.nextNameOffset), current + 1L)) continue;
            return current;
        }
    }

    private static final boolean shallDie$1(ActorCell $this, ActorRef ref2) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.shallDie(ref2))) continue;
            return true;
        }
    }

    private static final ChildrenContainer removeChild$1(ActorCell $this, ActorRef ref2) {
        while (true) {
            ChildrenContainer n;
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), n = c.remove(ref2))) continue;
            return n;
        }
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer$EmptyChildrenContainer$.MODULE$);
        $this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(0L);
    }
}

